% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nsx.R
\name{read_nsx}
\alias{read_nsx}
\title{Read ('BlackRock') 'NEV' 'NSx' data}
\usage{
read_nsx(
  file,
  extract_path = getOption("ieegio.extract_path", NULL),
  header_only = FALSE,
  cache_ok = TRUE,
  include_waveform = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{file}{file path to the data file}

\item{extract_path}{location to where the extracted information is to be
stored}

\item{header_only}{whether to only load header data}

\item{cache_ok}{whether existing cache should be reused; default is
\code{TRUE}. This input can speed up reading large data files; set to
\code{FALSE} to delete cache before importing.}

\item{include_waveform}{whether to include 'waveform' data (usually for
online spike sorting); default is \code{FALSE}}

\item{verbose}{whether to print processing messages; default is \code{TRUE}}
}
\value{
A cached object that is readily to be loaded to memory; see
\code{\link{SignalDataCache}} for class definition.
}
\description{
Read ('BlackRock') 'NEV' 'NSx' data
}
