% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{graph.knn}
\alias{graph.knn}
\title{Average nearest neighbor degree}
\usage{
graph.knn(
  graph,
  vids = V(graph),
  mode = c("all", "out", "in", "total"),
  neighbor.degree.mode = c("all", "out", "in", "total"),
  weights = NULL
)
}
\arguments{
\item{graph}{The input graph. It may be directed.}

\item{vids}{The vertices for which the calculation is performed. Normally it
includes all vertices. Note, that if not all vertices are given here, then
both \sQuote{\code{knn}} and \sQuote{\code{knnk}} will be calculated based
on the given vertices only.}

\item{mode}{Character constant to indicate the type of neighbors to consider
in directed graphs. \code{out} considers out-neighbors, \verb{in} considers
in-neighbors and \code{all} ignores edge directions.}

\item{neighbor.degree.mode}{The type of degree to average in directed graphs.
\code{out} averages out-degrees, \verb{in} averages in-degrees and \code{all}
ignores edge directions for the degree calculation.}

\item{weights}{Weight vector. If the graph has a \code{weight} edge
attribute, then this is used by default. If this argument is given, then
vertex strength (see \code{\link[=strength]{strength()}}) is used instead of vertex
degree. But note that \code{knnk} is still given in the function of the
normal vertex degree.
Weights are are used to calculate a weighted degree (also called
\code{\link[=strength]{strength()}}) instead of the degree.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{graph.knn()} was renamed to \code{knn()} to create a more
consistent API.
}
\keyword{internal}
