% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_sim.R
\name{score_sim}
\alias{score_sim}
\title{Calculating similarity between drug and disease}
\usage{
score_sim(BioDescr, method = "jaccard", n = 1000)
}
\arguments{
\item{BioDescr}{BioDescr object.}

\item{method}{method to compute similarity, default "jaccard". See \code{proxyC::simil}.}

\item{n}{number.}
}
\value{
A list.
}
\description{
Calculating drug-disease similarity based on biological descriptors
}
\examples{
\dontrun{
data(drugdemo)
drug_herb <- PrepareData(drugdemo$drug_herb, from = "drug", to="herb")
herb_compound <- PrepareData(drugdemo$herb_compound, from = "herb", to="compound")
compound_target <- PrepareData(drugdemo$compound_target, from = "compound", to="target")
disease <- PrepareData(drugdemo$disease, diseaseID = "disease",from = "target", to="target")
BasicData <- CreateBasicData(drug_herb, herb_compound, compound_target, diseasenet = disease)
biodescr <- extr_biodescr(BasicData, geneset= "kegg")
res <- score_sim(biodescr, method="jaccard", n=1000)
}
}
\author{
Yuanlong Hu
}
