% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.imptree}
\alias{predict.imptree}
\alias{print.evaluation_imptree}
\title{Classification with Imprecise Probabilities}
\usage{
\method{predict}{imptree}(object, data, dominance = c("strong", "max"),
  utility = 0.65, ...)

\method{print}{evaluation_imptree}(x, ...)
}
\arguments{
\item{object}{An object of class \code{imptree}. See details.}

\item{data}{Data.frame containing observations to be predicted.
If \code{NULL} the observations in the training set of \code{"object"}
are employed.}

\item{dominance}{Dominace criterion to be applied when predicting
classes. This may either be \code{"strong"} (default) or \code{"max"}.
See details.}

\item{utility}{Utility for the utility based accuracy measure for a 
vacuous prediction result (default: 0.65).}

\item{\dots}{Additional arguments for data. May be \code{"weights"},
\code{"subset"}, \code{"na.action"}, any further are discarded.}

\item{x}{an object of class \code{evaluation_imptree}}
}
\value{
\code{predict.imptree()} return an object of class 
\code{evaluation_imptree}, which is a named list containing 
predicted classes, predicted probability distribution and  accuracy 
evaluation
\item{probintlist}{List of the imprecise probability distributions of the
class variable. One matrix per observation in the test data.}
\item{classes}{Predicted class(es) of the observations as boolean matrix}
\item{evaluation}{Result of accuracy evaluation
\itemize{
\item{nObs}{: Number of observations}
\item{deter}{: Determinacy}
\item{nObsIndet}{: Number of observations with indeterminate prediction}
\item{indetSize}{: Average number of classes when predicting 
indeterminate (\code{NA} when no indeterminate observation)}
\item{acc_single}{: Single-set accuracy (\code{NA} when no determinate 
observation)}
\item{acc_set}{: Set-accuracy (\code{NA} when no indeterminate observation)}
\item{acc_disc}{: Discounted-accuracy}
\item{acc_util}{: Utility based (discounted) accuracy}
}}

The printing function returns the
\code{evaluation_imptree} object invisibly.
}
\description{
Prediction of \code{imptree} objects
}
\details{
This function carries out the prediction of an imprecise tree. 
An existence check on the stored C++ object reference is carried out 
at first. If the reference is not valid the original call
for \code{"object"} is printed as error.

There are currently 2 different dominance criteria available:
\describe{
\item{max}{Maximum frequency criterion. Dominance is decided only
by the upper bound of the probability interval, ie. a state \eqn{C_i} is 
dominated if there exists any \eqn{j \neq i}{j != i} with
\eqn{u(C_i) < u(C_j)}}
\item{strong}{Interval dominance criterion. For the IDM it
coincides with the strong dominance criterion. Here a state
\eqn{C_i} is dominated if there exists any \eqn{j \neq i}{j != i} 
with \eqn{u(C_i) < l(C_j)}}
}
}
\examples{
data("carEvaluation")

## create a tree with IDM (s=1) to full size
## carEvaluation, leaving the first 10 observations out
ip <- imptree(acceptance~., data = carEvaluation[-(1:10),], 
  method="IDM", method.param = list(splitmetric = "globalmax", s = 1), 
  control = list(depth = NULL, minbucket = 1))

## predict the first 10 observations with 'max' dominance
pp <- predict(ip, dominance = "max", data = carEvaluation[(1:10),])
print(pp)
pp$classes                ## predicted classes as logical matrix

## predict the first 10 observations with 'strong' dominance and
## use a different level of utility
predict(ip, dominance = "strong", data = carEvaluation[(1:10),],
        utility = 0.5)

}
\seealso{
\code{\link{imptree}}, \code{\link{node_imptree}}
}
\author{
Paul Fink \email{Paul.Fink@stat.uni-muenchen.de}
}
\keyword{tree}
