% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_istatdata.R
\name{get_istatdata}
\alias{get_istatdata}
\title{Download data set by agencyId, id and version (source: IstatData)}
\usage{
get_istatdata(agencyId,
             dataset_id,
             version,
             start=NULL,
             end=NULL,
             recent=FALSE,
             csv=FALSE,
             xlsx=FALSE)
}
\arguments{
\item{agencyId}{data set agencyId}

\item{dataset_id}{data set id}

\item{version}{data set version}

\item{start}{Time value for the start (NULL by default)}

\item{end}{Time value for the end (NULL bu default)}

\item{recent}{False by default, if TRUE, the function retrieves data from last 10 years}

\item{csv}{False by default, if TRUE, the function saves the data set to directory as .csv}

\item{xlsx}{False by default, if TRUE, the function saves the data set to directory as .xlsx}
}
\value{
It returns data set as data.frame. It can be saved to environment or as .csv/.xlsx.
}
\description{
Download data sets from IstatData (new ISTAT provider). Alternatively, use get_i_stat to download data sets from I.Stat (old ISTAT provider).
Note that in this first version of the package, only get_i_stat allows you to download variable labels, while get_istatdata has not this functionality yet.
The parameters "agencyId","dataset_id" and "version" to download the data sets can be found using list_istatdata function or search_istatdata function.
}
\note{
Downloading may take some time. Future versions will speed up the process.
}
\examples{
\donttest{get_istatdata("IT1", "12_60_DF_DCCV_CONSACQUA_2" , "1.0",recent = TRUE)}
\donttest{get_istatdata("IT1", "12_60_DF_DCCV_CONSACQUA_2" , "1.0", start = 2015, end = 2018)}
}
