% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.post_jointVIP}
\alias{summary.post_jointVIP}
\title{Obtains a summary post_jointVIP object}
\usage{
\method{summary}{post_jointVIP}(
  object,
  ...,
  smd = "cross-sample",
  use_abs = TRUE,
  bias_tol = 0.01,
  post_bias_tol = 0.005
)
}
\arguments{
\item{object}{a post_jointVIP object}

\item{...}{not used}

\item{smd}{specify the standardized mean difference is \code{cross-sample} or \code{pooled}}

\item{use_abs}{TRUE (default) for absolute measures}

\item{bias_tol}{numeric 0.01 (default) any bias above the absolute bias_tol will be summarized}

\item{post_bias_tol}{numeric 0.005 (default) any bias above the absolute bias_tol will be summarized}
}
\value{
no return value
}
\description{
Obtains a summary post_jointVIP object
}
\examples{
data <- data.frame(year = rnorm(50, 200, 5),
                   pop = rnorm(50, 1000, 500),
                   gdpPercap = runif(50, 100, 1000),
                   trt = rbinom(50, 1, 0.5),
                   out = rnorm(50, 1, 0.2))
# random 20 percent of control as pilot data
pilot_sample_num = sample(which(data$trt == 0),
                          length(which(data$trt == 0)) *
                          0.2)
pilot_df = data[pilot_sample_num, ]
analysis_df = data[-pilot_sample_num, ]
treatment = "trt"
outcome = "out"
covariates = names(analysis_df)[!names(analysis_df)
                                \%in\% c(treatment, outcome)]
new_jointVIP = create_jointVIP(treatment = treatment,
                               outcome = outcome,
                               covariates = covariates,
                               pilot_df = pilot_df,
                               analysis_df = analysis_df)

## at this step typically you may wish to do matching or weighting
## the results after can be stored as a post_data
## the post_data here is not matched or weighted, only for illustrative purposes
post_data <- data.frame(year = rnorm(50, 200, 5),
                        pop = rnorm(50, 1000, 500),
                        gdpPercap = runif(50, 100, 1000),
                        trt = rbinom(50, 1, 0.5),
                        out = rnorm(50, 1, 0.2))
post_dat_jointVIP = create_post_jointVIP(new_jointVIP, post_data)
summary(post_dat_jointVIP)
}
