% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph_hr.R
\name{coxph_hr}
\alias{coxph_hr}
\alias{a_coxph_hr}
\alias{s_coxph_hr}
\title{Workaround statistics function to add HR with CI}
\usage{
a_coxph_hr(
  df,
  .var,
  ref_path,
  .spl_context,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_coxph_hr(
  df,
  .ref_group,
  .in_ref_col,
  .var,
  is_event,
  strata = NULL,
  control = control_coxph(),
  alternative = c("two.sided", "less", "greater")
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{ref_path}{(\code{character})\cr global reference group specification, see \code{\link[=get_ref_info]{get_ref_info()}}.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{...}{additional arguments for the lower level functions.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{logical})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}

\item{is_event}{(\code{character})\cr variable name storing Logical values: \code{TRUE} if event,
\code{FALSE} if time to event is censored.}

\item{strata}{(\code{character} or \code{NULL})\cr variable names indicating stratification factors.}

\item{control}{(\code{list})\cr relevant list of control options.}

\item{alternative}{(\code{string})\cr whether \code{two.sided}, or one-sided \code{less} or \code{greater} p-value
should be displayed.}
}
\value{
for \code{s_coxph_hr} a list containing the same statistics returned by \link[tern:survival_coxph_pairwise]{tern::s_coxph_pairwise}
and the additional \code{lr_stat_df} statistic. for \code{a_coxph_hr}, a \code{VerticalRowsSection}
object.
}
\description{
This is a workaround for \code{\link[tern:survival_coxph_pairwise]{tern::s_coxph_pairwise()}}, which adds a statistic
containing the hazard ratio estimate together with the confidence interval.
}
\section{Functions}{
\itemize{
\item \code{a_coxph_hr()}: Formatted analysis function which is used as \code{afun}.

\item \code{s_coxph_hr()}: Statistics function forked from \code{\link[tern:survival_coxph_pairwise]{tern::s_coxph_pairwise()}}.
the difference is that:
\enumerate{
\item It returns the additional statistic \code{lr_stat_df} (log rank statistic with degrees of freedom).
}

}}
\examples{
library(dplyr)

adtte_f <- tern::tern_ex_adtte |>
  filter(PARAMCD == "OS") |>
  mutate(is_event = CNSR == 0)

df <- adtte_f |> filter(ARMCD == "ARM A")
df_ref_group <- adtte_f |> filter(ARMCD == "ARM B")

basic_table() |>
  split_cols_by(var = "ARMCD", ref_group = "ARM A") |>
  add_colcounts() |>
  analyze("AVAL",
    afun = s_coxph_hr,
    extra_args = list(is_event = "is_event"),
    var_labels = "Unstratified Analysis",
    show_labels = "visible"
  ) |>
  build_table(df = adtte_f)

basic_table() |>
  split_cols_by(var = "ARMCD", ref_group = "ARM A") |>
  add_colcounts() |>
  analyze("AVAL",
    afun = s_coxph_hr,
    extra_args = list(
      is_event = "is_event",
      strata = "SEX",
      control = tern::control_coxph(pval_method = "wald")
    ),
    var_labels = "Unstratified Analysis",
    show_labels = "visible"
  ) |>
  build_table(df = adtte_f)
adtte_f <- tern::tern_ex_adtte |>
  dplyr::filter(PARAMCD == "OS") |>
  dplyr::mutate(is_event = CNSR == 0)
df <- adtte_f |> dplyr::filter(ARMCD == "ARM A")
df_ref <- adtte_f |> dplyr::filter(ARMCD == "ARM B")

s_coxph_hr(
  df = df,
  .ref_group = df_ref,
  .in_ref_col = FALSE,
  .var = "AVAL",
  is_event = "is_event",
  strata = NULL
)
}
