% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_helper.R
\name{plot.fitted_dlm}
\alias{plot.fitted_dlm}
\title{Visualizing a fitted kDGLM model}
\usage{
\method{plot}{fitted_dlm}(
  x,
  outcomes = NULL,
  latent.states = NULL,
  linear.predictors = NULL,
  pred.cred = 0.95,
  lag = NA,
  cutoff = floor(x$t/10),
  plot.pkg = "auto",
  ...
)
}
\arguments{
\item{x}{fitted_dlm object: A fitted DGLM.}

\item{outcomes}{character: The name of the outcomes to plot.}

\item{latent.states}{character: The name of the latent states to plot.}

\item{linear.predictors}{character: The name of the linear predictors to plot.}

\item{pred.cred}{numeric: The credibility value for the credibility interval.}

\item{lag}{integer: The number of steps ahead to be used for prediction. If lag<0, the smoothed distribution is used and, if lag==0, the filtered interval.score is used.}

\item{cutoff}{integer: The number of initial steps that should be skipped in the plot. Usually, the model is still learning in the initial steps, so the predictions are not reliable.}

\item{plot.pkg}{character: A flag indicating if a plot should be produced. Should be one of 'auto', 'base', 'ggplot2' or 'plotly'.}

\item{...}{Extra arguments passed to the plot method.}
}
\value{
ggplot or plotly object: A plot showing the predictive mean and credibility interval with the observed data.
}
\description{
Calculate the predictive mean and some quantile for the observed data and show a plot.
}
\examples{
data <- c(AirPassengers)

level <- polynomial_block(rate = 1, order = 2, D = 0.95)
season <- harmonic_block(rate = 1, order = 2, period = 12, D = 0.975)

outcome <- Poisson(lambda = "rate", data)

fitted.data <- fit_model(level, season,
  AirPassengers = outcome
)

plot(fitted.data, plot.pkg = "base")

}
\seealso{
\code{\link{fit_model}}

Other auxiliary visualization functions for the fitted_dlm class: 
\code{\link{plot.dlm_coef}()},
\code{\link{summary.fitted_dlm}()},
\code{\link{summary.searched_dlm}()}
}
\concept{auxiliary visualization functions for the fitted_dlm class}
