#' Knowledge spaces on AutoCAD knowledge
#'
#' Bases of knowledge spaces on AutoCAD knowledge obtained from querying experts.
#'
#' Six experts were queried about prerequisite relationships between 28 AutoCAD
#' knowledge items (Dowling, 1991; 1993). A seventh basis represents those
#' prerequisite relationships on which the majority (4 out of 6) of the experts
#' agree (Dowling & Hockemeyer, 1998).
#'
#' @docType data
#'
#' @usage cad
#'
#' @format A list containing seven bases (cad1 to cad6, and cadmaj) in binary
#' matrix form. Each matrix has 28 columns representing the different knowledge
#' items and a varying number of rows containing the basis elements.
#'
#' @references Dowling, C. E. (1991). _Constructing Knowledge Structures from
#' the Judgements of Experts._ Habilitationsschrift, Technische Universität
#' Carolo-Wilhelmina, Braunschweig, Germany.
#'
#' Dowling, C. E. (1993). Applying the basis of a knowledge space for controlling
#' the questioning of an expert. _Journal of Mathematical Psychology, 37,_ 21–48.
#'
#' Dowling, C. E. & Hockemeyer, C. (1998). Computing the intersection of knowledge
#' spaces using only their basis. In Cornelia E. Dowling, Fred S. Roberts, & Peter
#' Theuns, editors, _Recent Progress in Mathematical Psychology,_ pp. 133–141.
#' Lawrence Erlbaum Associates Ltd., Mahwah, NJ.
#'
#' @family Data
"cad"
