% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nice_lavaanPlot.R
\name{nice_lavaanPlot}
\alias{nice_lavaanPlot}
\title{Make a quick \code{lavaanPlot}}
\usage{
nice_lavaanPlot(
  model,
  node_options = list(shape = "box", fontname = "Helvetica"),
  edge_options = c(color = "black"),
  coefs = TRUE,
  stand = TRUE,
  covs = FALSE,
  stars = c("regress", "latent", "covs"),
  sig = 0.05,
  graph_options = c(rankdir = "LR"),
  ...
)
}
\arguments{
\item{model}{SEM or CFA model to plot.}

\item{node_options}{Shape and font name.}

\item{edge_options}{Colour of edges.}

\item{coefs}{Logical, whether to plot coefficients. Defaults to TRUE.}

\item{stand}{Logical, whether to use standardized coefficients.
Defaults to TRUE.}

\item{covs}{Logical, whether to plot covariances. Defaults to FALSE.}

\item{stars}{Which links to plot significance stars for. One of
\code{c("regress", "latent", "covs")}.}

\item{sig}{Which significance threshold to use to plot coefficients (defaults
to .05). To plot all coefficients, set \code{sig} to 1.}

\item{graph_options}{Read from left to right, rather than from top to bottom.}

\item{...}{Arguments to be passed to function \link[lavaanPlot:lavaanPlot]{lavaanPlot::lavaanPlot}.}
}
\value{
A lavaanPlot, of classes \code{c("grViz", "htmlwidget")}, representing the
specified \code{lavaan} model.
}
\description{
Make a quick and decent-looking \code{lavaanPlot}.
}
\section{Illustrations}{


\if{html}{\figure{lavaanPlot.png}{options: width="400"}}
}

\examples{
\dontshow{if (requireNamespace("lavaan", quietly = TRUE) && requireNamespace("lavaanPlot", quietly = TRUE) && requireNamespace("DiagrammeRsvg", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x <- paste0("x", 1:9)
(latent <- list(
  visual = x[1:3],
  textual = x[4:6],
  speed = x[7:9]
))

HS.model <- write_lavaan(latent = latent)
cat(HS.model)

library(lavaan)
fit <- cfa(HS.model, HolzingerSwineford1939)
nice_lavaanPlot(fit)
\dontshow{\}) # examplesIf}
}
