% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/question_answers.R
\name{answer}
\alias{answer}
\alias{answer_fn}
\title{Question answer options}
\usage{
answer(text, correct = FALSE, message = NULL, label = text)

answer_fn(fn, label = NULL)
}
\arguments{
\item{text}{The answer text or value; for selection-type questions this value
is shown to the user.}

\item{correct}{Logical value indicating whether the \code{answer()} corresponds to
a correct or incorrect option.}

\item{message}{A custom message shown when this answer is selected and when
the overall question result matches the state of this answer. For example,
the \code{message} of a correct solution is not shown when the entire submission
is incorrect, but \emph{will} be shown when the user both picks this answer
option and the question is \emph{correct}.}

\item{label}{The label shown when the option is presented to the user.}

\item{fn}{A function used to evaluate the submitted answer. The function is
called with the student's submitted value as the first argument, so the
function should take at least one argument where the user's value will be
passed to the first argument. Inline \pkg{purrr}-style lambda functions
are allowed, see \code{\link[rlang:as_function]{rlang::as_function()}} for complete details on the syntax.

In the body of the function, you can perform arbitrary calculations to
decide if the submitted answer is or is not correct and to compose the
message presented to the user. To signal a final answer, call \code{\link[=mark_as]{mark_as()}}
or its helper functions \code{\link[=correct]{correct()}} or \code{\link[=incorrect]{incorrect()}}. All other return
values are ignored; e.g. by returning \code{NULL} you may yield the submission
evaluation to other \code{\link[=answer]{answer()}} or \code{\link[=answer_fn]{answer_fn()}} options for the question.}
}
\value{
Returns a list with the \code{"tutorial_question_answer"} class.
}
\description{
Create options for users when used in \code{\link[=question_checkbox]{question_checkbox()}} and
\code{\link[=question_radio]{question_radio()}} learnr questions. For \code{\link[=question_text]{question_text()}} and
\code{\link[=question_numeric]{question_numeric()}}, the individual answers aren't directly presented to
students, but their values can be used in determining if the student
submitted the correct answer. For flexible feedback from checkbox, text, and
numeric questions, \code{answer_fn()} can be used to provide a function that
evaluates the student's submission and returns a custom result.
}
\section{Functions}{
\itemize{
\item \code{answer()}: Create an answer option

\item \code{answer_fn()}: Evaluate the student's submission to determine correctness
and to return feedback.

}}
\examples{
answer(32, correct = FALSE)
answer(42, correct = TRUE, message = "The meaning of life.")

}
