% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LayoutElasticSearch.R
\name{LayoutElasticSearch}
\alias{LayoutElasticSearch}
\title{Format log events for output to ElasticSearch}
\value{
The \verb{$new()} method returns an \link[R6:R6Class]{R6::R6} that inherits from
\link[lgr:Layout]{lgr::Layout} and can used as a Layout by an \link[lgr:Appender]{lgr::Appender}.
}
\description{
Similar to \link[lgr:LayoutJson]{lgr::LayoutJson}, but with some modifications to prepare data
for ElasticSearch.
}
\seealso{
Other Layout: 
\code{\link{LayoutDbi}}
}
\concept{Layout}
\section{Super class}{
\code{\link[lgr:Layout]{lgr::Layout}} -> \code{LayoutElasticSearch}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{toJSON_args}}{a list of values passed on to \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}}

\item{\code{transform_event}}{a \code{function} with a single argument \code{event} that
takes a \link[lgr:LogEvent]{lgr::LogEvent} and returns a \code{list}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LayoutElasticSearch-new}{\code{LayoutElasticSearch$new()}}
\item \href{#method-LayoutElasticSearch-format_event}{\code{LayoutElasticSearch$format_event()}}
\item \href{#method-LayoutElasticSearch-set_toJSON_args}{\code{LayoutElasticSearch$set_toJSON_args()}}
\item \href{#method-LayoutElasticSearch-set_transform_event}{\code{LayoutElasticSearch$set_transform_event()}}
\item \href{#method-LayoutElasticSearch-clone}{\code{LayoutElasticSearch$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Layout" data-id="set_excluded_fields"><a href='../../lgr/html/Layout.html#method-Layout-set_excluded_fields'><code>lgr::Layout$set_excluded_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="lgr" data-topic="Layout" data-id="toString"><a href='../../lgr/html/Layout.html#method-Layout-toString'><code>lgr::Layout$toString()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutElasticSearch-new"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutElasticSearch-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutElasticSearch$new(
  toJSON_args = list(auto_unbox = TRUE),
  transform_event = function(event) get("values", event)
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutElasticSearch-format_event"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutElasticSearch-format_event}{}}}
\subsection{Method \code{format_event()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutElasticSearch$format_event(event)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutElasticSearch-set_toJSON_args"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutElasticSearch-set_toJSON_args}{}}}
\subsection{Method \code{set_toJSON_args()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutElasticSearch$set_toJSON_args(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutElasticSearch-set_transform_event"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutElasticSearch-set_transform_event}{}}}
\subsection{Method \code{set_transform_event()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutElasticSearch$set_transform_event(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LayoutElasticSearch-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LayoutElasticSearch-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LayoutElasticSearch$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
