% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsarray.R
\encoding{UTF-8}
\name{dsarray}
\alias{dsarray}
\title{Create a Data Step Array}
\usage{
dsarray(...)
}
\arguments{
\item{...}{Column names to include as part of the datastep array.  The 
names can be provided as quoted strings or a vector of strings.
If names are provided as quoted strings, separate the strings with commas 
(i.e. \code{dsarray("col1", "col2", "col3")}).}
}
\value{
The datastep array object.
}
\description{
A data step array is an object that allows you to iterate
across a set of columns inside a \code{\link{datastep}}.  This structure is
useful when you need to perform the same or similar operations on many columns.
}
\details{
The datastep array has an indexer that allows you to access a particular
column value.  The indexer can be used within a for loop to iterate over
the array. In this manner, you can place a set of conditions inside
the for loop and run the same conditional logic on all the columns 
in the array. 

You can also use the datastep array with an empty indexer in vectorized 
functions like \code{\link[base]{sum}}, \code{\link[base]{mean}}, 
and \code{\link[base]{max}}.  The empty indexer will return all the 
values in the array for the current row.
}
\examples{
library(libr)

# Create AirPassengers Data Frame
df <- as.data.frame(t(matrix(AirPassengers, 12, 
                    dimnames = list(month.abb, seq(1949, 1960)))),
                    stringsAsFactors = FALSE)

# Use datastep array to get year tot, mean, and top month
dat <- datastep(df,
                arrays = list(months = dsarray(names(df))),
                attrib = list(Tot = 0, Mean = 0, Top = ""),
                drop = "mth",
                {
                
                  Tot <- sum(months[])
                  Mean <- mean(months[])
                
                  for (mth in months) {
                    if (months[mth] == max(months[])) {
                      Top <- mth
                    }
                  }
                  
                })

dat
#      Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec  Tot     Mean Top
# 1949 112 118 132 129 121 135 148 148 136 119 104 118 1520 126.6667 Aug
# 1950 115 126 141 135 125 149 170 170 158 133 114 140 1676 139.6667 Aug
# 1951 145 150 178 163 172 178 199 199 184 162 146 166 2042 170.1667 Aug
# 1952 171 180 193 181 183 218 230 242 209 191 172 194 2364 197.0000 Aug
# 1953 196 196 236 235 229 243 264 272 237 211 180 201 2700 225.0000 Aug
# 1954 204 188 235 227 234 264 302 293 259 229 203 229 2867 238.9167 Jul
# 1955 242 233 267 269 270 315 364 347 312 274 237 278 3408 284.0000 Jul
# 1956 284 277 317 313 318 374 413 405 355 306 271 306 3939 328.2500 Jul
# 1957 315 301 356 348 355 422 465 467 404 347 305 336 4421 368.4167 Aug
# 1958 340 318 362 348 363 435 491 505 404 359 310 337 4572 381.0000 Aug
# 1959 360 342 406 396 420 472 548 559 463 407 362 405 5140 428.3333 Aug
# 1960 417 391 419 461 472 535 622 606 508 461 390 432 5714 476.1667 Jul
}
\seealso{
\code{\link{libname}} to create a data library, and
\code{\link{dictionary}} for generating a data dictionary

Other datastep: 
\code{\link{[.dsarray}()},
\code{\link{datastep}()},
\code{\link{dsattr}()},
\code{\link{length.dsarray}()}
}
\concept{datastep}
