% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simple_api.R
\name{detect_component_type}
\alias{detect_component_type}
\title{Detect Component Type Based on Output ID Patterns}
\usage{
detect_component_type(component_id, data_reactive)
}
\arguments{
\item{component_id}{Character string. The ID of the output component to classify.}

\item{data_reactive}{Reactive data object (currently unused in the function logic).}
}
\value{
Character string indicating the detected component type:
\itemize{
\item "leaflet" - for IDs containing "map" or "leaflet"
\item "datatable" - for IDs containing "table" or "dt", or as default
}
}
\description{
\code{detect_component_type} is an internal function that attempts to automatically determine the type of
'shiny' output component based on common naming patterns in the component ID.
This function uses simple heuristics to classify components as either
"leaflet" (for maps) or "datatable" (for tables), with "datatable" as the
default fallback.
}
\details{
The function uses case-insensitive pattern matching on the component ID:
\itemize{
\item IDs containing "map" or "leaflet" are classified as "leaflet"
\item IDs containing "table" or "dt" are classified as "datatable"
\item All other IDs default to "datatable" with a warning message
}
}
\note{
This is an internal function that provides basic auto-detection capabilities.
For more precise control over component types, use the explicit register_*
functions instead.
}
\keyword{internal}
