% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{model.matrix.logitr}
\alias{model.matrix.logitr}
\title{Construct Design Matrices}
\usage{
\method{model.matrix}{logitr}(object, ...)
}
\arguments{
\item{object}{an object of an appropriate class. For the default method,
a model \code{formula} or a \code{terms} object.}

\item{...}{further arguments.}
}
\value{
A design matrix
}
\description{
Creates a design (or model) matrix, e.g., by expanding factors to a set of
dummy variables (depending on the contrasts) and expanding interactions
similarly.
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Get the model.matrix design matrix
model.matrix(mnl_pref)
}
\keyword{logitr}
\keyword{model.matrix}
