% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric.R
\name{np_elife}
\alias{np_elife}
\title{Nonparametric estimation of the survival function}
\usage{
np_elife(
  time,
  time2 = NULL,
  event = NULL,
  type = c("right", "left", "interval", "interval2"),
  thresh = 0,
  ltrunc = NULL,
  rtrunc = NULL,
  tol = 1e-12,
  weights = NULL,
  method = c("em", "sqp"),
  arguments = NULL,
  ...
)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{event}{status indicator, normally 0=alive, 1=dead. Other choices are \code{TRUE}/\code{FALSE} (\code{TRUE} for death).
For interval censored data, the status indicator is 0=right censored, 1=event at time, 2=left censored, 3=interval censored.
Although unusual, the event indicator can be omitted, in which case all subjects are assumed to have experienced an event.}

\item{type}{character string specifying the type of censoring. Possible values are "\code{right}", "\code{left}", "\code{interval}", "\code{interval2}".}

\item{thresh}{double thresh}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}

\item{tol}{double, relative tolerance for convergence of the EM algorithm}

\item{weights}{double, vector of weights for the observations}

\item{method}{string, one of \code{"em"} for expectation-maximization (EM) algorithm or \code{"sqp"} for sequential quadratic programming with augmented Lagrange multiplie method.}

\item{arguments}{a named list specifying default arguments of the function that are common to all \code{elife} calls}

\item{...}{additional arguments, currently ignored}
}
\value{
a list with elements
\itemize{
\item \code{cdf}: right-continuous \code{stepfun} object defined by probabilities
\item \code{time}: matrix of unique values for the Turnbull intervals defining equivalence classes; only those with non-zero probabilities are returned
\item \code{prob}: \code{J} vector of non-zero probabilities
\item \code{niter}: number of iterations
}
}
\description{
The survival function is obtained through the EM algorithm
described in Turnbull (1976); censoring and truncation are
assumed to be non-informative.
The survival function changes only at the \code{J} distinct
exceedances \eqn{y_i-u} and truncation points.
}
\details{
The unknown parameters of the model are \eqn{p_j (j=1, \ldots, J)}
subject to the constraint that \eqn{\sum_{j=1}^J p_j=1}.
}
\examples{
set.seed(2021)
n <- 20L
# Create fake data
ltrunc <- pmax(0, runif(n, -0.5, 1))
rtrunc <- runif(n, 6, 10)
dat <- samp_elife(n = n,
                  scale = 1,
                  shape = -0.1,
                  lower = ltrunc,
                  upper = rtrunc,
                  family = "gp",
                  type2 = "ltrt")
npi <- np_elife(time = dat,
                rtrunc = rtrunc,
                ltrunc = ltrunc)
print(npi)
summary(npi)
plot(npi)
}
\references{
Turnbull, B. W. (1976). \emph{The Empirical Distribution Function with Arbitrarily Grouped, Censored and Truncated Data.} Journal of the Royal Statistical Society. Series B (Methodological) 38(\bold{3}), 290–295.

Gentleman, R. and C. J. Geyer (1994). \emph{Maximum likelihood for interval censored data: Consistency and computation}, Biometrika, 81(\bold{3}), 618–623.

Frydman, H. (1994). \emph{A Note on Nonparametric Estimation of the Distribution Function from Interval-Censored and Truncated Observations}, Journal of the Royal Statistical Society. Series B (Methodological) \bold{56}(1), 71-74.
}
