% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{luz_callback_gradient_clip}
\alias{luz_callback_gradient_clip}
\title{Gradient clipping callback}
\usage{
luz_callback_gradient_clip(max_norm = 1, norm_type = 2)
}
\arguments{
\item{max_norm}{(float or int): max norm of the gradients}

\item{norm_type}{(float or int): type of the used p-norm. Can be \code{Inf} for
infinity norm.}
}
\description{
By adding the GradientClip callback, the gradient \code{norm_type} (default:2) norm
is clipped to at most \code{max_norm} (default:1) using \code{\link[torch:nn_utils_clip_grad_norm_]{torch::nn_utils_clip_grad_norm_()}},
which can avoid loss divergence.
}
\references{
See FastAI \href{https://docs.fast.ai/callback.training.html#GradientClip}{documentation}
for the GradientClip callback.
}
