% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks-mixup.R
\name{luz_callback_mixup}
\alias{luz_callback_mixup}
\title{Mixup callback}
\usage{
luz_callback_mixup(alpha = 0.4, ..., run_valid = FALSE, auto_loss = FALSE)
}
\arguments{
\item{alpha}{parameter for the beta distribution used to sample mixing coefficients}

\item{...}{currently unused. Just to force named arguments.}

\item{run_valid}{Should it run during validation}

\item{auto_loss}{Should it automatically modify the loss function? This will wrap
the loss function to create the mixup loss. If \code{TRUE} make sure that your loss
function does not apply reductions. If \code{run_valid=FALSE}, then loss will be
mean reduced during validation.}
}
\value{
A \code{luz_callback}
}
\description{
Implementation of \href{https://arxiv.org/abs/1710.09412}{'mixup: Beyond Empirical Risk Minimization'}.
As of today, tested only for categorical data,
where targets are expected to be integers, not one-hot encoded vectors.
This callback is supposed to be used together with \code{\link[=nn_mixup_loss]{nn_mixup_loss()}}.
}
\details{
Overall, we follow the \href{https://github.com/fastai/fastai/blob/master/fastai/callback/mixup.py}{fastai implementation}
described \href{https://forums.fast.ai/t/mixup-data-augmentation/22764}{here}.
Namely,
\itemize{
\item We work with a single dataloader only, randomly mixing two observations from the same batch.
\item We linearly combine losses computed for both targets:
\code{loss(output, new_target) = weight * loss(output, target1) + (1-weight) * loss(output, target2)}
\item We draw different mixing coefficients for every pair.
\item We replace \code{weight} with \code{weight = max(weight, 1-weight)} to avoid duplicates.
}
}
\examples{
if (torch::torch_is_installed()) {
mixup_callback <- luz_callback_mixup()
}

}
\seealso{
\code{\link[=nn_mixup_loss]{nn_mixup_loss()}}, \code{\link[=nnf_mixup]{nnf_mixup()}}

Other luz_callbacks: 
\code{\link{luz_callback}()},
\code{\link{luz_callback_auto_resume}()},
\code{\link{luz_callback_csv_logger}()},
\code{\link{luz_callback_early_stopping}()},
\code{\link{luz_callback_interrupt}()},
\code{\link{luz_callback_keep_best_model}()},
\code{\link{luz_callback_lr_scheduler}()},
\code{\link{luz_callback_metrics}()},
\code{\link{luz_callback_mixed_precision}()},
\code{\link{luz_callback_model_checkpoint}()},
\code{\link{luz_callback_profile}()},
\code{\link{luz_callback_progress}()},
\code{\link{luz_callback_resume_from_checkpoint}()},
\code{\link{luz_callback_train_valid}()}
}
\concept{luz_callbacks}
