% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_med_mod_parallel}
\alias{data_med_mod_parallel}
\title{Sample Dataset: Parallel
Mediation with Two Moderators}
\format{
A data frame with 100 rows
and 8 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w1}{Moderator 1. Numeric.}
\item{w2}{Moderator 2. Numeric.}
\item{m1}{Mediator 1. Numeric.}
\item{m2}{Mediator 2. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med_mod_parallel
}
\description{
A parallel mediation
model with a1-path and b2-path
moderated.
}
\examples{
library(lavaan)
data(data_med_mod_parallel)
data_med_mod_parallel$xw1 <-
 data_med_mod_parallel$x *
 data_med_mod_parallel$w1
data_med_mod_parallel$m2w2 <-
 data_med_mod_parallel$m2 *
 data_med_mod_parallel$w2
mod <-
"
m1 ~ a1 * x + w1 + da1 * xw1 + c1 + c2
m2 ~ a2 * x + w1 + c1 + c2
y ~ b1 * m1 + b2 * m2 + x + w1 + w2 + db2 * m2w2 + c1 + c2
w1 ~~ v_w1 * w1
w1 ~ m_w1 * 1
w2 ~~ v_w2 * w2
w2 ~ m_w2 * 1
a1b1 := a1 * b1
a2b2 := a2 * b2
a1b1_w1lo := (a1 + da1 * (m_w1 - sqrt(v_w1))) * b1
a1b1_w1hi := (a1 + da1 * (m_w1 + sqrt(v_w1))) * b2
a2b2_w2lo := a2 * (b2 + db2 * (m_w2 - sqrt(v_w2)))
a2b2_w2hi := a2 * (b2 + db2 * (m_w2 + sqrt(v_w2)))
"
fit <- sem(mod, data_med_mod_parallel,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 3, 6, 10, 11, 15, 48:53), ]
}
\keyword{datasets}
