% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_ison.R
\docType{data}
\name{irps_revere}
\alias{irps_revere}
\title{Two-mode network of Paul Revere's (Fischer 1995)}
\format{
\if{html}{\out{<div class="sourceCode">}}\preformatted{#> # A labelled, two-mode network of 261 nodes and 319 ties
#> 
#> -- Nodes
#> # A tibble: 261 x 2
#>   type  name              
#>   <lgl> <chr>             
#> 1 FALSE Adams.John        
#> 2 FALSE Adams.Samuel      
#> 3 FALSE Allen.Dr          
#> 4 FALSE Appleton.Nathaniel
#> 5 FALSE Ash.Gilbert       
#> 6 FALSE Austin.Benjamin   
#> # i 255 more rows
#> 
#> -- Ties
#> # A tibble: 319 x 2
#>    from    to
#>   <int> <int>
#> 1     1   257
#> 2     1   258
#> 3     2   257
#> 4     2   258
#> 5     2   260
#> 6     2   261
#> # i 313 more rows
#> 
}\if{html}{\out{</div>}}
}
\usage{
data(irps_revere)
}
\description{
This network is of Paul Revere and 253 of his contemporary's overlapping
memberships in seven colonial organisations.
The data has been collected by Kieran Healy from the appendix to
David Hackett Fischer's "Paul Revere's Ride".
It highlights Paul Revere's centrality in this network, and thus his
ability to mobilise the towns he rode through on horseback north
from Boston on the night of April 18, 1775.
This is in contrast to William Dawes, who set out the same night,
but south.
Despite both men coming from similar class and backgrounds,
and riding through towns with similar demography and political leanings,
only Paul Revere was able to mobilise those he encountered,
and his social network was thought key to this.
}
\references{
Fischer, David Hackett. 1995.
"Paul Revere's Ride".
Oxford: Oxford University Press.

Han, Shin-Kap. 2009.
"The Other Ride of Paul Revere: The Brokerage Role in the Making of the American Revolution".
\emph{Mobilization: An International Quarterly}, 14(2): 143-162.
\doi{10.17813/maiq.14.2.g360870167085210}

Healy, Kieran. 2013.
"Using Metadata to find Paul Revere".
}
\keyword{datasets}
