% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapbayest_ofv_computation.R
\name{h}
\alias{h}
\title{Compute the H matrix}
\usage{
h(pred, cmt, all_cmt, ...)
}
\arguments{
\item{pred}{predictions (typically obtained from \code{f()})}

\item{cmt}{compartments predictions belong to (typically the \code{cmt} column of the dataset)}

\item{all_cmt}{all possible compartments with observations as defined in the model in \verb{$SIGMA}}

\item{...}{for compatibility (not used)}
}
\value{
a matrix of dimensions \verb{[length(pred), 2 * length(all_cmt)]}
}
\description{
Partial derivative of predictions with respect to epsilon
}
\examples{
mapbayr:::h(
pred = c(400, 40, 200, 20),
cmt = c(2, 3, 2, 3),
all_cmt = c(2, 3)
)
}
