/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.preprocessor;

import choco.Choco;
import choco.cp.common.util.preprocessor.AbstractAdvancedDetector;
import choco.cp.model.CPModel;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.common.util.iterators.DisposableIterator;
import choco.kernel.model.constraints.Constraint;
import choco.kernel.model.constraints.ConstraintType;
import choco.kernel.model.variables.Variable;
import choco.kernel.model.variables.integer.IntegerExpressionVariable;
import choco.kernel.model.variables.integer.IntegerVariable;
import java.util.Iterator;

public class SymetryBreakingModelDetector
extends AbstractAdvancedDetector {
    private IntegerVariable[] maxclique = null;

    public SymetryBreakingModelDetector(CPModel model) {
        super(model);
    }

    public void setMaxClique(IntegerVariable[] clique) {
        if (this.maxclique == null || this.maxclique.length < clique.length) {
            this.maxclique = clique;
        }
    }

    @Override
    public final void apply() {
        if (this.maxclique != null && SymetryBreakingModelDetector.checkOnlyOneDomain(this.model) && SymetryBreakingModelDetector.checkOnlyDiff(this.model)) {
            DisposableIntIterator it = this.model.getIntVar(0).getDomainIterator();
            for (int i = 0; i < this.maxclique.length && it.hasNext(); ++i) {
                this.model.addConstraint(Choco.eq((IntegerExpressionVariable)this.maxclique[i], it.next()));
            }
            it.dispose();
        }
    }

    private static boolean checkOnlyOneDomain(CPModel m) {
        Iterator<IntegerVariable> it = m.getIntVarIterator();
        if (it.hasNext()) {
            IntegerVariable v = it.next();
            int lb = v.getLowB();
            int ub = v.getUppB();
            if (v.getValues() != null) {
                return false;
            }
            while (it.hasNext()) {
                IntegerVariable v2 = it.next();
                if (v2.getLowB() == lb && v2.getUppB() == ub && v2.getValues() == null) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean checkOnlyDiff(CPModel m) {
        Iterator<Constraint> it = m.getConstraintIterator();
        while (it.hasNext()) {
            Constraint ct = it.next();
            if (ct.getConstraintType() == ConstraintType.ALLDIFFERENT || ct.getConstraintType() == ConstraintType.NEQ && !SymetryBreakingModelDetector.isComplexNeq(ct)) continue;
            return false;
        }
        return true;
    }

    private static boolean isComplexNeq(Constraint ct) {
        if (ct.getConstraintType().equals((Object)ConstraintType.NEQ)) {
            DisposableIterator<Variable> it = ct.getVariableIterator();
            while (it.hasNext()) {
                if (it.next() instanceof IntegerVariable) continue;
                return true;
            }
        }
        return false;
    }

    public static final class EmptySymetryBreakingModelDetector
    extends SymetryBreakingModelDetector {
        public EmptySymetryBreakingModelDetector(CPModel model) {
            super(model);
        }

        @Override
        public void setMaxClique(IntegerVariable[] clique) {
        }
    }
}

