% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{OnePointCrossOverOnDoublesUsingBytes}
\alias{OnePointCrossOverOnDoublesUsingBytes}
\title{One-point Crossover operation on the two vectors of doubles using their byte representations}
\usage{
OnePointCrossOverOnDoublesUsingBytes(d1, d2, cutpoint)
}
\arguments{
\item{d1}{A vector of doubles of the first parent}

\item{d2}{A vector of doubles of the second parent}

\item{cutpoint}{An integer between 1 and chromosome length for crossover cutting}
}
\value{
List of two double vectors of offspring
}
\description{
This function is a C++ wrapper for crossing-over of two double vectors of candidate solutions using their byte representations
}
\examples{
d1 <- runif(3)
d2 <- runif(3)
cutp <- sample(1:(length(d1)*SizeOfDouble()), 1)[1]
offspring <- OnePointCrossOverOnDoublesUsingBytes(d1,d2, cutp)
print("Parents:")
print(d1)
print(d2)
print("Offspring:")
print(offspring[[1]])
print(offspring[[2]])
}
\author{
Mehmet Hakan Satman - mhsatman@istanbul.edu.tr
}
\seealso{
OnePointCrossOver

UniformCrossOverOnDoublesUsingBytes
}

