% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/30_align.R
\name{dohCluster}
\alias{dohCluster}
\title{Cluster Based Peak Alignment}
\usage{
dohCluster(
  X,
  peakList,
  refInd = 0,
  maxShift = 100,
  acceptLostPeak = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{X}{Dataframe of signal intensities from all spectra as returned by
\code{\link[=gen_feat_mat]{gen_feat_mat()}}.}

\item{peakList}{List of peak indices as returned \code{\link[=gen_feat_mat]{gen_feat_mat()}}.}

\item{refInd}{Number of the reference spectrum i.e. the spectrum to which all
signals will be aligned to.}

\item{maxShift}{Maximum number of points a value can be moved.}

\item{acceptLostPeak}{Whether to allow the the alignment algorithm to ignore
peaks that cannot easily be aligned with the reference spectrum.}

\item{verbose}{Whether to print additional information during the alignment
process.}
}
\value{
A list containing two data frames \code{Y} and \code{new_peakList}. The first one
contains the aligned spectra, the second one contains the aligned signals of
each spectrum.
}
\description{
Rewrite of \code{speaq::dohCluster()}, compatible with the data format returned by
'generate_lorentz_curves()' and 'gen_feat_mat()'. The function name
"dohCluster" comes from "Do Hierarchical Clustering" which is part of the
Alignment algorithm proposed by Vu et al. (2011) in
\url{doi:10.1186/1471-2105-12-405}.
}
\examples{
sim_subset <- metabodecon_file("bruker/sim_subset")
decons <- generate_lorentz_curves_sim(sim_subset)
feat <- gen_feat_mat(decons)
refObj <- speaq::findRef(feat$peakList)
hclObj <- dohCluster(
     X = feat$data_matrix,
     peakList = feat$peakList,
     refInd = refObj$refInd,
     maxShift = 100,
     acceptLostPeak = TRUE,
     verbose = TRUE
)
str(hclObj, 1)
}
\author{
Initial version from Wolfram Gronwald.
Refactored by Tobias Schmidt in 2024.
}
