% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/10_spec.R
\name{read_spectra}
\alias{read_spectra}
\title{Read one or more spectra from Disk}
\usage{
read_spectra(
  data_path = pkg_file("example_datasets/bruker/urine"),
  file_format = "bruker",
  expno = 10,
  procno = 10,
  raw = FALSE,
  silent = TRUE,
  force = FALSE
)
}
\arguments{
\item{data_path}{The path of the file/folder containing the spectrum data. E.g.
\code{"example_datasets/jcampdx/urine/urine_1.dx"} or
\code{"example_datasets/bruker/urine/urine"}.}

\item{file_format}{The file_format of the spectrum file. E.g. \code{"bruker"} or \code{"jcampdx"}.}

\item{expno, procno}{The experiment/processing number for the file. E.g. \code{"10"}. Only relevant if
\code{file_format} equals \code{"bruker"}. For details see section \href{https://spang-lab.github.io/metabodecon/articles/FAQ.html#file-structure}{File Structure} in
the metabodecon FAQ.}

\item{raw}{If \code{FALSE}, scales the returned signal intensities based on information
available in the spectrum metadata, in particular \code{NC_proc}. For details see
\code{processing-reference.pdf}, available at \url{https://www.bruker.com/en.html} at
section 'Services & Support > Documentation & Manuals > Magnetic Resonance >
Acquisition & Processing > TopSpin Processing Commands and Parameters'
(requires login).}

\item{silent}{If \code{TRUE}, no output will be printed to the console.}

\item{force}{If \code{TRUE}, try to continue when encountering errors and print info messages
instead. To hide these messages as well, set \code{silent = TRUE}.}
}
\value{
A \code{spectrum} object as described in \link{metabodecon_classes}.
}
\description{
\code{read_spectrum()} reads a single spectrum from disk and returns it as
\code{spectrum} object. \code{read_spectra()} can be used to read multiple spectra at
once and returns a \code{spectra} object.
}
\examples{
relpath <- "example_datasets/bruker/urine"
urine <- system.file(relpath, package = "metabodecon")
urine_1 <- file.path(urine, "urine_1")
urine_2 <- file.path(urine, "urine_2")
x1 <- read_spectrum(urine_1)
x2 <- read_spectrum(urine_2)
xx <- read_spectra(urine)
str(xx)
str(x1)
stopifnot(all.equal(x1, xx$urine_1))
}
