% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/old_taxa--taxonomy--docs.R
\name{stems}
\alias{stems}
\title{Get stem taxa}
\arguments{
\item{obj}{The [taxonomy()] or [taxmap()] object containing taxon
information to be queried.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to find stems for.
Default: All taxa in `obj` will be used. Any variable name that appears in
[all_names()] can be used as if it was a vector on its own.}

\item{value}{What data to return. This is usually the name of column in a
table in `obj$data`. Any result of `all_names(obj)` can be used, but it
usually only makes sense to data that corresponds to taxa 1:1, such as
[taxon_ranks()]. By default, taxon indexes are returned.}

\item{simplify}{(`logical`) If `TRUE`, then combine all the results
into a single vector of unique values.}

\item{exclude_leaves}{(`logical`) If `TRUE`, the do not include
taxa with no subtaxa.}
}
\value{
`character`
}
\description{
Return the stem taxa for a [taxonomy()] or a [taxmap()]
object. Stem taxa are all those from the roots to the first taxon with more
than one subtaxon.
\preformatted{
obj$stems(subset = NULL, simplify = FALSE,
  value = "taxon_indexes", exclude_leaves = FALSE)
stems(obj, subset = NULL, simplify = FALSE,
  value = "taxon_indexes", exclude_leaves = FALSE)}
}
\examples{
# Return indexes of stem taxa
stems(ex_taxmap)

# Return indexes for a subset of taxa
stems(ex_taxmap, subset = 2:17)

# Return something besides taxon indexes
stems(ex_taxmap, value = "taxon_names")

# Return a vector instead of a list
stems(ex_taxmap, value = "taxon_names", simplify = TRUE)

}
\seealso{
Other taxonomy indexing functions: 
\code{\link{branches}()},
\code{\link{internodes}()},
\code{\link{leaves}()},
\code{\link{roots}()},
\code{\link{subtaxa}()},
\code{\link{supertaxa}()}
}
\concept{taxonomy indexing functions}
