% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Event.Split.R
\name{EventSplit2}
\alias{EventSplit2}
\title{Event split with two time-scales, time and gaptime}
\usage{
EventSplit2(
  data,
  time = "time",
  status = "status",
  entry = "start",
  cuts = "cuts",
  name.id = "id",
  gaptime = NULL,
  gaptime.entry = NULL,
  cuttime = c("time", "gaptime"),
  cens.code = 0,
  order.id = TRUE
)
}
\arguments{
\item{data}{data to be split}

\item{time}{time variable.}

\item{status}{status variable.}

\item{entry}{name of entry variable.}

\item{cuts}{cuts variable or numeric cut (only one value)}

\item{name.id}{name of id variable.}

\item{gaptime}{gaptime variable.}

\item{gaptime.entry}{name of entry variable for gaptime.}

\item{cuttime}{to cut after time or gaptime}

\item{cens.code}{code for the censoring.}

\item{order.id}{order data after id and start.}
}
\description{
Cuts time for two time-scales, as event.split
}
\examples{
rr  <- data.frame(time=c(500,1000),start=c(0,500),status=c(1,1),id=c(1,1))
rr$gaptime <-  rr$time-rr$start
rr$gapstart <- 0

rr1 <- EventSplit2(rr,cuts=600,cuttime="time",   gaptime="gaptime",gaptime.entry="gapstart")
rr2 <- EventSplit2(rr1,cuts=100,cuttime="gaptime",gaptime="gaptime",gaptime.entry="gapstart")

dlist(rr1,start-time+status+gapstart+gaptime~id)
dlist(rr2,start-time+status+gapstart+gaptime~id)

}
\author{
Thomas Scheike
}
\keyword{survival}
