% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{npar}
\alias{npar}
\alias{npar.default}
\alias{npar.micsr}
\title{Number of parameters of a fitted model}
\usage{
npar(x, subset = NULL)

\method{npar}{default}(x, subset = NULL)

\method{npar}{micsr}(x, subset = NULL)
}
\arguments{
\item{x}{a fitted model}

\item{subset}{a character indicating the subset of coefficients
(only relevant for \code{micsr} models).}
}
\value{
an integer.
}
\description{
The number of observation of a fitted model is typically obtained
using the \code{nobs} method. There is no such generics to extract the
same information about the number of parameters. \code{npar} is such a
generic and has a special method for \code{micsr} objects with a
\code{subset} argument that enables to compute the number of parameters
for a subset of coefficients. The default method returns the length
of the vector of coefficients extracted using the \code{coef} function.
}
\author{
Yves Croissant
}
\keyword{misc}
