% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatcher.R
\name{dispatcher}
\alias{dispatcher}
\title{Dispatcher}
\usage{
dispatcher(host, url = NULL, n = 0L, ...)
}
\arguments{
\item{host}{the character URL dispatcher should dial in to, typically an IPC
address.}

\item{url}{the character URL dispatcher should listen at (and daemons should
dial in to), including the port to connect to e.g. tcp://hostname:5555' or
'tcp://10.75.32.70:5555'. Specify 'tls+tcp://' to use secure TLS
connections.}

\item{n}{[default 0L] if specified, the integer number of daemons to be
launched locally by the host process.}

\item{...}{(optional) additional arguments passed through to \code{\link[=daemon]{daemon()}} if
launching daemons. These include \code{asyncdial}, \code{autoexit}, \code{cleanup},
\code{output}, \code{maxtasks}, \code{idletime}, \code{walltime} and \code{tlscert}.}
}
\value{
Invisible NULL.
}
\description{
Dispatches tasks from a host to daemons for processing, using FIFO
scheduling, queuing tasks as required. Daemon / dispatcher settings are
controlled by \code{\link[=daemons]{daemons()}} and this function should not need to be called
directly.
}
\details{
The network topology is such that a dispatcher acts as a gateway between the
host and daemons, ensuring that tasks received from the host are dispatched
on a FIFO basis for processing. Tasks are queued at the dispatcher to ensure
tasks are only sent to daemons that can begin immediate execution of the
task.
}
