% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateK.R
\name{generateK}
\alias{generateK}
\title{Generate Standard Gaussian samples with a Gaussian transiiton kernel}
\usage{
generateK(X, N = 100, thinning = 4, sigma = 1, lsf, burnin = 20)
}
\arguments{
\item{X}{the seeds for the Markov Chain. There are as many MC drawn as given
seeds}

\item{N}{the number of desired samples"'}

\item{thinning}{the proportion of kept samples, ie. 1 each \code{thinning} draw.}

\item{sigma}{the exploration parameter for the transition kernel}

\item{lsf}{a boolean limit-state function for definig a subdomain of the input
space.}

\item{burnin}{the \code{burnin} parameter, ie. the number of discarded samples
before keeping one.}
}
\value{
A matrix \code{X} with the number of desired samples
}
\description{
Generate Standard Gaussian samples with a Gaussian transiiton kernel
}
\details{
This function generates standard Gaussian samples with a Markov Chain
using a suitable transition kernel
}
\examples{
# Get a seed in dimension 2
X <- matrix(rnorm(2), nrow = 2)
X <- generateK(X, N = 1000)

library(ggplot2)
ggplot(as.data.frame(t(X)), aes(x_1,x_2)) + geom_point()

# One can also specify a limit-state function
lsf <- function(X){
     sqrt(colSums(X^2)) > 2
}
X <- matrix(c(2, 2), nrow = 2)
X <- generateK(X, N = 1000, lsf = lsf)

ggplot(as.data.frame(t(X)), aes(x_1,x_2)) + geom_point()

}
\author{
Clement WALTER \email{clementwalter@icloud.com}
}
