#'
#' @title Cricket
#' @description Multivariate time series (MTS) of four cricket umpires performing twelve signals, each with ten repetitions.
#' @usage data(Cricket)
#' @format A \code{list} with two elements, which are:
#' \describe{
#' \item{\code{data}}{A list with 180 MTS.}
#' \item{\code{classes}}{A numeric vector indicating the corresponding classes associated with the elements in \code{data}.}
#' }
#' @details Each element in \code{data} is a matrix formed by 1197 rows (time points) indicating acceleration and 6 columns (variables) indicating spatial dimension
#' with regards to two accelerometers. The first 108 elements
#' correspond to the training set, whereas the last 72 elements correspond to the test set. The numeric vector \code{classes} is formed
#' by integers from 1 to 12, indicating that there are 12 different classes in the database. Each class is associated with a different
#' event signaled by the umpire. For more information, see \insertCite{bagnall2018uea;textual}{mlmts}.
#' Run install.packages("ueadata1", repos="https://anloor7.github.io/drat")
#' to access this dataset and use the syntax ueadata1::Cricket.
#' @references{
#'
#'   \insertRef{bagnall2018uea}{mlmts}
#'
#'   \insertRef{ruiz2021great}{mlmts}
#'
#'   \insertRef{bagnallweb}{mlmts}
#'
#' }
"Cricket"

