% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CnfAtom.R
\name{CnfAtom}
\alias{CnfAtom}
\alias{\%among\%}
\alias{as.CnfAtom}
\title{Atoms for CNF Formulas}
\usage{
CnfAtom(symbol, values)

e1 \%among\% e2

as.CnfAtom(x)
}
\arguments{
\item{symbol}{(\code{\link{CnfSymbol}}) \cr
The symbol to which the atom refers.}

\item{values}{(\code{character}) \cr
The values that the symbol can take.}

\item{e1}{(\code{CnfSymbol}) \cr
Left-hand side of the \verb{\%among\%} operator.
Passed as \code{symbol} to \code{CnfAtom()}.}

\item{e2}{(\code{character}) \cr
Right-hand side of the \verb{\%among\%} operator.
Passed as \code{values} to \code{CnfAtom()}.}

\item{x}{(any) \cr
The object to be coerced to a \code{CnfAtom} by \code{as.CnfAtom}.
Only \code{logical(1)} and \code{CnfAtom} itself are currently supported.}
}
\value{
A new \code{CnfAtom} object.
}
\description{
\code{CnfAtom} objects represent a single statement that is used to build up CNF formulae.
They are mostly intermediate, created using the \code{\link{\%among\%}} operator or \code{\link[=CnfAtom]{CnfAtom()}}
directly, and combined into \code{\link{CnfClause}} and \code{\link{CnfFormula}} objects.
\code{\link{CnfClause}} and \code{\link{CnfFormula}} do not, however, contain \code{\link{CnfAtom}} objects directly,

\code{CnfAtom}s contain an indirect reference to a \code{\link{CnfSymbol}} by referencing its name
and its \code{\link{CnfUniverse}}. They furthermore contain a set of values. An \code{CnfAtom}
represents a statement asserting that the given symbol takes up one of the
given values.

If the set of values is empty, the \code{CnfAtom} represents a contradiction (FALSE).
If it is the full domain of the symbol, the \code{CnfAtom} represents a tautology (TRUE).
These values can be converted to, and from, \code{logical(1)} values using \code{as.logical()}
and \code{as.CnfAtom()}.

\code{CnfAtom} objects can be negated using the \code{!} operator, which will return the \code{CnfAtom}
representing set membership in the complement of the symbol with respect to its domain.
\code{CnfAtom}s can furthermore be combined using the \code{|} operator to form a \code{\link{CnfClause}},
and using the \code{&} operator to form a \code{\link{CnfFormula}}. This happens even if the
resulting statement could be represented as a single \code{CnfAtom}.

This is part of the CNF representation tooling, which is currently considered
experimental; it is for internal use.
}
\details{
We would have preferred to overload the \code{\%in\%} operator, but this is currently
not easily possible in R. We therefore created the \verb{\%among\%} operator.

The internal representation of a \code{CnfAtom} may change in the future.
}
\examples{
u = CnfUniverse()
X = CnfSymbol(u, "X", c("a", "b", "c"))

CnfAtom(X, c("a", "b"))
X \%among\% "a"
X \%among\% character(0)
X \%among\% c("a", "b", "c")

as.logical(X \%among\% character(0))
as.CnfAtom(TRUE)

!(X \%among\% "a")

X \%among\% "a" | X \%among\% "b"  # creates a CnfClause

X \%among\% "a" & X \%among\% c("a", "b")  # creates a CnfFormula
}
\seealso{
Other CNF representation objects: 
\code{\link{CnfClause}()},
\code{\link{CnfFormula}()},
\code{\link{CnfSymbol}()},
\code{\link{CnfUniverse}()}
}
\concept{CNF representation objects}
\keyword{internal}
