% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TunerAsyncFromOptimizerAsync.R
\name{TunerAsyncFromOptimizerAsync}
\alias{TunerAsyncFromOptimizerAsync}
\title{TunerAsyncFromOptimizerAsync}
\description{
Internally used to transform \link[bbotk:Optimizer]{bbotk::Optimizer} to \link{Tuner}.
}
\keyword{internal}
\section{Super classes}{
\code{\link[mlr3tuning:Tuner]{mlr3tuning::Tuner}} -> \code{\link[mlr3tuning:TunerAsync]{mlr3tuning::TunerAsync}} -> \code{TunerAsyncFromOptimizerAsync}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{param_set}}{(\link[paradox:ParamSet]{paradox::ParamSet})\cr
Set of control parameters.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TunerAsyncFromOptimizerAsync-new}{\code{TunerAsyncFromOptimizerAsync$new()}}
\item \href{#method-TunerAsyncFromOptimizerAsync-optimize}{\code{TunerAsyncFromOptimizerAsync$optimize()}}
\item \href{#method-TunerAsyncFromOptimizerAsync-clone}{\code{TunerAsyncFromOptimizerAsync$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="format"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-format'><code>mlr3tuning::Tuner$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="help"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-help'><code>mlr3tuning::Tuner$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3tuning" data-topic="Tuner" data-id="print"><a href='../../mlr3tuning/html/Tuner.html#method-Tuner-print'><code>mlr3tuning::Tuner$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerAsyncFromOptimizerAsync-new"></a>}}
\if{latex}{\out{\hypertarget{method-TunerAsyncFromOptimizerAsync-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerAsyncFromOptimizerAsync$new(optimizer, man = NA_character_)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{optimizer}}{\link[bbotk:Optimizer]{bbotk::Optimizer}\cr
Optimizer that is called.}

\item{\code{man}}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerAsyncFromOptimizerAsync-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-TunerAsyncFromOptimizerAsync-optimize}{}}}
\subsection{Method \code{optimize()}}{
Performs the tuning on a \link{TuningInstanceBatchSingleCrit} /
\link{TuningInstanceBatchMultiCrit} until termination. The single evaluations and
the final results will be written into the \link{ArchiveAsyncTuning} that
resides in the \link{TuningInstanceBatchSingleCrit}/\link{TuningInstanceBatchMultiCrit}.
The final result is returned.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerAsyncFromOptimizerAsync$optimize(inst)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{inst}}{(\link{TuningInstanceBatchSingleCrit} | \link{TuningInstanceBatchMultiCrit}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\link[data.table:data.table]{data.table::data.table}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TunerAsyncFromOptimizerAsync-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TunerAsyncFromOptimizerAsync-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TunerAsyncFromOptimizerAsync$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
