% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov_struct.R
\name{cov_struct}
\alias{cov_struct}
\title{Define a Covariance Structure}
\usage{
cov_struct(
  type = cov_types(),
  visits,
  subject,
  group = character(),
  heterogeneous = FALSE
)
}
\arguments{
\item{type}{(\code{string})\cr the name of the covariance structure type to use.
For available options, see \code{cov_types()}. If a type abbreviation is used
that implies heterogeneity (e.g. \code{cph}) and no value is provided to
\code{heterogeneous}, then the heterogeneity is derived from the type name.}

\item{visits}{(\code{character})\cr a vector of variable names to use for the
longitudinal terms of the covariance structure. Multiple terms are only
permitted for the \code{"spatial"} covariance type.}

\item{subject}{(\code{string})\cr the name of the variable that encodes a subject
identifier.}

\item{group}{(\code{string})\cr optionally, the name of the variable that encodes
a grouping variable for subjects.}

\item{heterogeneous}{(\code{flag})\cr}
}
\value{
A \code{cov_struct} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
cov_struct("csh", "AVISITN", "USUBJID")
cov_struct("spatial", c("VISITA", "VISITB"), group = "GRP", subject = "SBJ")

}
\seealso{
Other covariance types: 
\code{\link{as.cov_struct}()},
\code{\link{covariance_types}}
}
\concept{covariance types}
