% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_convert.R
\name{to_move}
\alias{to_move}
\title{Convert a move2 object to a move object}
\usage{
to_move(x)
}
\arguments{
\item{x}{a \code{move2} object.}
}
\value{
an object of the class \code{Move}/\code{MoveStack}

\code{to_move} converts back to a objects from the \code{move} package. When multiple individuals are provided a
\code{\link[move]{MoveStack-class}} is created otherwise a \code{\link[move]{Move-class}} object.
}
\description{
Convert a move2 object to a move object
}
\details{
Note that the individuals are ordered as they occur in the event data in the created
\code{\link[move]{MoveStack-class}} object as the order needs to correspond there between the event and track data
for \code{move}.
}
\examples{
\donttest{
if (requireNamespace("move")) {
  data(leroy, package = "move")
  leroy_move2 <- mt_as_move2(leroy)
  to_move(leroy_move2)
}
}
}
\seealso{
Other move2-convert: 
\code{\link{mt_as_move2}()}
}
\concept{move2-convert}
