% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom-tol.R
\name{use_custom_tol}
\alias{use_custom_tol}
\alias{use_scalar_tol}
\title{Set up a model object to use either scalar or custom tolerances}
\usage{
use_custom_tol(x)

use_scalar_tol(x)
}
\arguments{
\item{x}{a model object.}
}
\value{
An updated model object.
}
\description{
Call \code{use_custom_tol()} to use custom relative and absolute tolerances in
a model; call \code{use_scalar_tol()} to revert to the traditional configuration
where a single \code{rtol} and \code{atol} are applied to all compartments.
}
\details{
If customized tolerances have not been initialized yet, they will be,
assigning the current \code{rtol} or \code{atol} for every compartment. These default
values can be updated using \code{\link[=custom_rtol]{custom_rtol()}}, \code{\link[=custom_atol]{custom_atol()}}, or
\code{\link[=custom_tol]{custom_tol()}}.
}
\examples{
mod <- house()

mod <- use_custom_tol(mod)
mod

mod <- use_scalar_tol(mod)
mod

}
\seealso{
\code{\link[=custom_tol]{custom_tol()}}, \code{\link[=reset_tol]{reset_tol()}}, \code{\link[=get_tol]{get_tol()}}
}
