% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msaenet.R
\name{msaenet}
\alias{msaenet}
\title{Multi-Step Adaptive Elastic-Net}
\usage{
msaenet(x, y, family = c("gaussian", "binomial", "poisson", "cox"),
  init = c("enet", "ridge"), alphas = seq(0.05, 0.95, 0.05),
  tune = c("cv", "ebic", "bic", "aic"), nfolds = 5L,
  rule = c("lambda.min", "lambda.1se"), ebic.gamma = 1, nsteps = 2L,
  tune.nsteps = c("max", "ebic", "bic", "aic"), ebic.gamma.nsteps = 1,
  scale = 1, seed = 1001, parallel = FALSE, verbose = FALSE)
}
\arguments{
\item{x}{Data matrix.}

\item{y}{Response vector if \code{family} is \code{"gaussian"},
\code{"binomial"}, or \code{"poisson"}. If \code{family} is
\code{"cox"}, a response matrix created by \code{\link[survival]{Surv}}.}

\item{family}{Model family, can be \code{"gaussian"},
\code{"binomial"}, \code{"poisson"}, or \code{"cox"}.}

\item{init}{Type of the penalty used in the initial
estimation step. Can be \code{"enet"} or \code{"ridge"}.
See \code{\link[glmnet]{glmnet}} for details.}

\item{alphas}{Vector of candidate \code{alpha}s to use in
\code{\link[glmnet]{cv.glmnet}}.}

\item{tune}{Parameter tuning method for each estimation step.
Possible options are \code{"cv"}, \code{"ebic"}, \code{"bic"},
and \code{"aic"}. Default is \code{"cv"}.}

\item{nfolds}{Fold numbers of cross-validation when \code{tune = "cv"}.}

\item{rule}{Lambda selection criterion when \code{tune = "cv"},
can be \code{"lambda.min"} or \code{"lambda.1se"}.
See \code{\link[glmnet]{cv.glmnet}} for details.}

\item{ebic.gamma}{Parameter for Extended BIC penalizing
size of the model space when \code{tune = "ebic"},
default is \code{1}. For details, see Chen and Chen (2008).}

\item{nsteps}{Maximum number of adaptive estimation steps.
At least \code{2}, assuming adaptive elastic-net has only
one adaptive estimation step.}

\item{tune.nsteps}{Optimal step number selection method
(aggregate the optimal model from the each step and compare).
Options include \code{"max"} (select the final-step model directly),
or compare these models using \code{"ebic"}, \code{"bic"}, or \code{"aic"}.
Default is \code{"max"}.}

\item{ebic.gamma.nsteps}{Parameter for Extended BIC penalizing
size of the model space when \code{tune.nsteps = "ebic"},
default is \code{1}.}

\item{scale}{Scaling factor for adaptive weights:
\code{weights = coefficients^(-scale)}.}

\item{seed}{Two random seeds for cross-validation fold division
in two estimation steps.}

\item{parallel}{Logical. Enable parallel parameter tuning or not,
default is {FALSE}. To enable parallel tuning, load the
\code{doParallel} package and run \code{registerDoParallel()}
with the number of CPU cores before calling this function.}

\item{verbose}{Should we print out the estimation progress?}
}
\value{
List of model coefficients, \code{glmnet} model object,
and the optimal parameter set.
}
\description{
Multi-Step Adaptive Elastic-Net
}
\examples{
dat = msaenet.sim.gaussian(
  n = 150, p = 500, rho = 0.6,
  coef = rep(1, 5), snr = 2, p.train = 0.7,
  seed = 1001)

msaenet.fit = msaenet(
  dat$x.tr, dat$y.tr,
  alphas = seq(0.2, 0.8, 0.2),
  nsteps = 3L, seed = 1003)

print(msaenet.fit)
msaenet.nzv(msaenet.fit)
msaenet.fp(msaenet.fit, 1:5)
msaenet.tp(msaenet.fit, 1:5)
msaenet.pred = predict(msaenet.fit, dat$x.te)
msaenet.rmse(dat$y.te, msaenet.pred)
plot(msaenet.fit)
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\references{
Nan Xiao and Qing-Song Xu. (2015). Multi-step adaptive elastic-net:
reducing false positives in high-dimensional variable selection.
\emph{Journal of Statistical Computation and Simulation} 85(18), 3755--3765.
}

