% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-msaenet.R
\name{plot.msaenet}
\alias{plot.msaenet}
\title{Plot msaenet Model Objects}
\usage{
\method{plot}{msaenet}(x, type = c("coef", "criterion", "dotplot"),
  nsteps = NULL, highlight = TRUE, col = NULL, label = FALSE,
  label.vars = NULL, label.pos = 2, label.offset = 0.3,
  label.cex = 0.7, label.srt = 90, xlab = NULL, ylab = NULL,
  abs = FALSE, ...)
}
\arguments{
\item{x}{An object of class \code{msaenet} produced
by \code{\link{aenet}}, \code{amnet}, \code{asnet},
\code{\link{msaenet}}, \code{\link{msamnet}}, or \code{\link{msasnet}}.}

\item{type}{Plot type, \code{"coef"} for a coefficient path plot
across all estimation steps; \code{"criterion"} for a scree plot of
the model evaluation criterion used (CV error, AIC, BIC, or EBIC);
\code{"dotplot"} for a Cleveland dot plot of the coefficients
estimated by the model at the optimal step.}

\item{nsteps}{Maximum number of estimation steps to plot.
Default is to plot all steps.}

\item{highlight}{Should we highlight the "optimal" step
according to the criterion? Default is \code{TRUE}.}

\item{col}{Color palette to use for the coefficient paths.
If it is \code{NULL}, a default color palette will be assigned.}

\item{label}{Should we label all the non-zero variables of the
optimal step in the coefficient plot or the dot plot?
Default is \code{FALSE}. If \code{TRUE} and \code{label.vars = NULL},
the index of the non-zero variables will be used as labels.}

\item{label.vars}{Labels to use for all the variables
if \code{label = "TRUE"}.}

\item{label.pos}{Position of the labels. See argument
\code{pos} in \code{\link[graphics]{text}} for details.}

\item{label.offset}{Offset of the labels. See argument
\code{offset} in \code{\link[graphics]{text}} for details.}

\item{label.cex}{Character expansion factor of the labels.
See argument \code{cex} in \code{\link[graphics]{text}} for details.}

\item{label.srt}{Label rotation in degrees for the Cleveland dot plot.
Default is \code{90}. See argument \code{srt} in
\code{\link[graphics]{par}} for details.}

\item{xlab}{Title for x axis. If is \code{NULL}, will use the default title.}

\item{ylab}{Title for y axis. If is \code{NULL}, will use the default title.}

\item{abs}{Should we plot the absolute values of the coefficients
instead of the raw coefficients in the Cleveland dot plot?
Default is \code{FALSE}.}

\item{...}{Other parameters (not used).}
}
\description{
Plot msaenet model objects.
}
\examples{
dat <- msaenet.sim.gaussian(
  n = 150, p = 500, rho = 0.6,
  coef = rep(1, 5), snr = 2, p.train = 0.7,
  seed = 1001
)

msasnet.fit <- msasnet(
  dat$x.tr, dat$y.tr,
  alphas = seq(0.2, 0.8, 0.2),
  nsteps = 5L, tune.nsteps = "ebic",
  seed = 1003
)

plot(msasnet.fit)
plot(msasnet.fit, label = TRUE)
plot(msasnet.fit, label = TRUE, nsteps = 5)
plot(msasnet.fit, type = "criterion")
plot(msasnet.fit, type = "criterion", nsteps = 5)
plot(msasnet.fit, type = "dotplot", label = TRUE)
plot(msasnet.fit, type = "dotplot", label = TRUE, abs = TRUE)
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
