% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{nEffective}
\alias{nEffective}
\title{Estimate the effective sample size from longitudinal data}
\usage{
nEffective(n, k, icc, dv, id, data, family = c("gaussian", "binomial"))
}
\arguments{
\item{n}{The number of unique/indepedent units of observation}

\item{k}{The (average) number of observations per unit}

\item{icc}{The estimated ICC.  If missing, will
estimate (and requires that the family argument be
correctly specified).}

\item{dv}{A character string giving the variable name of
the dependent variable.}

\item{id}{A character vector of length one giving
the ID variable.}

\item{data}{A data.table containing the variables
used in the formula.  This is a required argument.
If a data.frame, it will silently coerce to a data.table.
If not a data.table or data.frame, it will attempt to coerce,
with a message.}

\item{family}{A character vector giving the family to use
for the model.  Currently only supports
\dQuote{gaussian} or \dQuote{binomial}.}
}
\value{
A data.table including the effective sample size.
}
\description{
This function estimates the (approximate) effective sample
size.
}
\examples{
## example where n, k, and icc are estimated from the data
## provided, partly using iccMixed function
nEffective(dv = "mpg", id = "cyl", data = mtcars)

## example where n, k, and icc are known (or being 'set')
## useful for sensitivity analyses
nEffective(n = 60, k = 10, icc = .6)
}
\references{
For details, see
Campbell, M. K., Mollison, J., and Grimshaw, J. M. (2001)
<doi:10.1002/1097-0258(20010215)20:3%3C391::AID-SIM800%3E3.0.CO;2-Z>
"Cluster trials in implementation research: estimation of intracluster correlation coefficients and sample size."
}
\keyword{multivariate}
