/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.WeightedGraph;
import org.jgrapht.alg.interfaces.WeightedMatchingAlgorithm;

public class KuhnMunkresMinimalWeightBipartitePerfectMatching<V, E>
implements WeightedMatchingAlgorithm<V, E> {
    private final WeightedGraph<V, E> graph;
    private final List<? extends V> firstPartition;
    private final List<? extends V> secondPartition;
    private final int[] matching;

    public KuhnMunkresMinimalWeightBipartitePerfectMatching(WeightedGraph<V, E> G, List<? extends V> S, List<? extends V> T) {
        if (S.size() != T.size()) {
            throw new IllegalArgumentException("Graph supplied isn't complete bipartite with equally sized partitions!");
        }
        int partition = S.size();
        int edges = G.edgeSet().size();
        if (edges != partition * partition) {
            throw new IllegalArgumentException("Graph supplied isn't complete bipartite with equally sized partitions!");
        }
        this.graph = G;
        this.firstPartition = S;
        this.secondPartition = T;
        this.matching = new KuhnMunkresMatrixImplementation<V, E>(G, S, T).buildMatching();
    }

    @Override
    public Set<E> getMatching() {
        HashSet edges = new HashSet();
        for (int i = 0; i < this.matching.length; ++i) {
            edges.add(this.graph.getEdge(this.firstPartition.get(i), this.secondPartition.get(this.matching[i])));
        }
        return edges;
    }

    @Override
    public double getMatchingWeight() {
        double weight2 = 0.0;
        for (E edge : this.getMatching()) {
            weight2 += this.graph.getEdgeWeight(edge);
        }
        return weight2;
    }

    protected static class KuhnMunkresMatrixImplementation<V, E> {
        private double[][] costMatrix;
        private double[][] excessMatrix;
        boolean[] rowsCovered;
        boolean[] columnsCovered;
        private int[] columnMatched;
        private int[] rowMatched;

        public KuhnMunkresMatrixImplementation(WeightedGraph<V, E> G, List<? extends V> S, List<? extends V> T) {
            int partition = S.size();
            this.costMatrix = new double[partition][];
            for (int i = 0; i < S.size(); ++i) {
                V source = S.get(i);
                this.costMatrix[i] = new double[partition];
                for (int j = 0; j < T.size(); ++j) {
                    V target = T.get(j);
                    if (source.equals(target)) continue;
                    this.costMatrix[i][j] = G.getEdgeWeight(G.getEdge(source, target));
                }
            }
        }

        protected int[] buildMatching() {
            int height = this.costMatrix.length;
            int width = this.costMatrix[0].length;
            this.excessMatrix = this.makeExcessMatrix();
            this.rowsCovered = new boolean[height];
            this.columnsCovered = new boolean[width];
            this.columnMatched = new int[height];
            this.rowMatched = new int[width];
            Arrays.fill(this.columnMatched, -1);
            Arrays.fill(this.rowMatched, -1);
            while (this.buildMaximalMatching() < width) {
                this.buildVertexCoverage();
                this.extendEqualityGraph();
            }
            return Arrays.copyOf(this.columnMatched, height);
        }

        double[][] makeExcessMatrix() {
            int i;
            double[][] excessMatrix = new double[this.costMatrix.length][];
            for (i = 0; i < excessMatrix.length; ++i) {
                excessMatrix[i] = Arrays.copyOf(this.costMatrix[i], this.costMatrix[i].length);
            }
            for (i = 0; i < excessMatrix.length; ++i) {
                int j;
                double cheapestTaskCost = Double.MAX_VALUE;
                for (j = 0; j < excessMatrix[i].length; ++j) {
                    if (!(cheapestTaskCost > excessMatrix[i][j])) continue;
                    cheapestTaskCost = excessMatrix[i][j];
                }
                j = 0;
                while (j < excessMatrix[i].length) {
                    double[] dArray = excessMatrix[i];
                    int n = j++;
                    dArray[n] = dArray[n] - cheapestTaskCost;
                }
            }
            for (int j = 0; j < excessMatrix[0].length; ++j) {
                int i2;
                double cheapestWorkerCost = Double.MAX_VALUE;
                for (i2 = 0; i2 < excessMatrix.length; ++i2) {
                    if (!(cheapestWorkerCost > excessMatrix[i2][j])) continue;
                    cheapestWorkerCost = excessMatrix[i2][j];
                }
                for (i2 = 0; i2 < excessMatrix.length; ++i2) {
                    double[] dArray = excessMatrix[i2];
                    int n = j;
                    dArray[n] = dArray[n] - cheapestWorkerCost;
                }
            }
            return excessMatrix;
        }

        int buildMaximalMatching() {
            int matchingSizeLowerBound = 0;
            for (int i = 0; i < this.columnMatched.length; ++i) {
                if (this.columnMatched[i] == -1) continue;
                ++matchingSizeLowerBound;
            }
            block1: for (int j = 0; j < this.excessMatrix[0].length; ++j) {
                if (this.rowMatched[j] != -1) continue;
                for (int i = 0; i < this.excessMatrix.length; ++i) {
                    if (this.excessMatrix[i][j] != 0.0 || this.columnMatched[i] != -1) continue;
                    ++matchingSizeLowerBound;
                    this.columnMatched[i] = j;
                    this.rowMatched[j] = i;
                    continue block1;
                }
            }
            if (matchingSizeLowerBound == this.excessMatrix[0].length) {
                return matchingSizeLowerBound;
            }
            boolean[] rowsVisited = new boolean[this.excessMatrix.length];
            boolean[] colsVisited = new boolean[this.excessMatrix[0].length];
            int matchingSize = 0;
            boolean extending = true;
            while (extending && matchingSize < this.excessMatrix.length) {
                int j;
                Arrays.fill(rowsVisited, false);
                Arrays.fill(colsVisited, false);
                extending = false;
                for (j = 0; j < this.excessMatrix.length; ++j) {
                    if (this.rowMatched[j] != -1 || colsVisited[j]) continue;
                    extending |= new MatchExtender(rowsVisited, colsVisited).extend(j);
                }
                matchingSize = 0;
                for (j = 0; j < this.rowMatched.length; ++j) {
                    if (this.rowMatched[j] == -1) continue;
                    ++matchingSize;
                }
            }
            return matchingSize;
        }

        void buildVertexCoverage() {
            int i;
            int j;
            Arrays.fill(this.columnsCovered, false);
            Arrays.fill(this.rowsCovered, false);
            boolean[] invertible = new boolean[this.rowsCovered.length];
            block0: for (int i2 = 0; i2 < this.excessMatrix.length; ++i2) {
                if (this.columnMatched[i2] != -1) {
                    invertible[i2] = true;
                    continue;
                }
                for (j = 0; j < this.excessMatrix[i2].length; ++j) {
                    if (Double.valueOf(this.excessMatrix[i2][j]).compareTo(0.0) != 0) continue;
                    invertible[i2] = true;
                    this.rowsCovered[i2] = true;
                    continue block0;
                }
            }
            boolean cont = true;
            while (cont) {
                for (i = 0; i < this.excessMatrix.length; ++i) {
                    if (!this.rowsCovered[i]) continue;
                    for (int j2 = 0; j2 < this.excessMatrix[i].length; ++j2) {
                        if (Double.valueOf(this.excessMatrix[i][j2]).compareTo(0.0) != 0 || this.columnsCovered[j2]) continue;
                        this.columnsCovered[j2] = true;
                    }
                }
                cont = false;
                for (j = 0; j < this.columnsCovered.length; ++j) {
                    if (!this.columnsCovered[j] || this.rowMatched[j] == -1 || this.rowsCovered[this.rowMatched[j]]) continue;
                    cont = true;
                    this.rowsCovered[this.rowMatched[j]] = true;
                }
            }
            for (i = 0; i < this.rowsCovered.length; ++i) {
                if (!invertible[i]) continue;
                int n = i;
                this.rowsCovered[n] = this.rowsCovered[n] ^ true;
            }
            assert (KuhnMunkresMatrixImplementation.uncovered(this.excessMatrix, this.rowsCovered, this.columnsCovered) == 0);
            assert (KuhnMunkresMatrixImplementation.minimal(this.rowMatched, this.rowsCovered, this.columnsCovered));
        }

        void extendEqualityGraph() {
            int j;
            int i;
            double minExcess = Double.MAX_VALUE;
            for (i = 0; i < this.excessMatrix.length; ++i) {
                if (this.rowsCovered[i]) continue;
                for (j = 0; j < this.excessMatrix[i].length; ++j) {
                    if (this.columnsCovered[j] || !(minExcess > this.excessMatrix[i][j])) continue;
                    minExcess = this.excessMatrix[i][j];
                }
            }
            for (i = 0; i < this.excessMatrix.length; ++i) {
                if (!this.rowsCovered[i]) continue;
                j = 0;
                while (j < this.excessMatrix[i].length) {
                    double[] dArray = this.excessMatrix[i];
                    int n = j++;
                    dArray[n] = dArray[n] + minExcess;
                }
            }
            for (int j2 = 0; j2 < this.excessMatrix[0].length; ++j2) {
                if (this.columnsCovered[j2]) continue;
                for (int i2 = 0; i2 < this.excessMatrix.length; ++i2) {
                    double[] dArray = this.excessMatrix[i2];
                    int n = j2;
                    dArray[n] = dArray[n] - minExcess;
                }
            }
        }

        private static boolean minimal(int[] match, boolean[] rowsCovered, boolean[] colsCovered) {
            int matched = 0;
            for (int i = 0; i < match.length; ++i) {
                if (match[i] == -1) continue;
                ++matched;
            }
            int covered = 0;
            for (int i = 0; i < rowsCovered.length; ++i) {
                if (rowsCovered[i]) {
                    ++covered;
                }
                if (!colsCovered[i]) continue;
                ++covered;
            }
            return matched == covered;
        }

        private static int uncovered(double[][] excessMatrix, boolean[] rowsCovered, boolean[] colsCovered) {
            int uncoveredZero = 0;
            for (int i = 0; i < excessMatrix.length; ++i) {
                if (rowsCovered[i]) continue;
                for (int j = 0; j < excessMatrix[i].length; ++j) {
                    if (colsCovered[j] || Double.valueOf(excessMatrix[i][j]).compareTo(0.0) != 0) continue;
                    ++uncoveredZero;
                }
            }
            return uncoveredZero;
        }

        protected class MatchExtender {
            private final boolean[] rowsVisited;
            private final boolean[] colsVisited;

            private MatchExtender(boolean[] rowsVisited, boolean[] colsVisited) {
                this.rowsVisited = rowsVisited;
                this.colsVisited = colsVisited;
            }

            public boolean extend(int initialCol) {
                return this.extendMatchingEL(initialCol);
            }

            private boolean extendMatchingOL(int pathTailRow, int pathTailCol) {
                if (KuhnMunkresMatrixImplementation.this.columnMatched[pathTailRow] == -1) {
                    ((KuhnMunkresMatrixImplementation)KuhnMunkresMatrixImplementation.this).columnMatched[pathTailRow] = pathTailCol;
                    ((KuhnMunkresMatrixImplementation)KuhnMunkresMatrixImplementation.this).rowMatched[pathTailCol] = pathTailRow;
                    return true;
                }
                this.rowsVisited[pathTailRow] = true;
                if (this.colsVisited[KuhnMunkresMatrixImplementation.this.columnMatched[pathTailRow]]) {
                    return false;
                }
                boolean extending = this.extendMatchingEL(KuhnMunkresMatrixImplementation.this.columnMatched[pathTailRow]);
                if (extending) {
                    ((KuhnMunkresMatrixImplementation)KuhnMunkresMatrixImplementation.this).columnMatched[pathTailRow] = pathTailCol;
                    ((KuhnMunkresMatrixImplementation)KuhnMunkresMatrixImplementation.this).rowMatched[pathTailCol] = pathTailRow;
                }
                return extending;
            }

            private boolean extendMatchingEL(int pathTailCol) {
                this.colsVisited[pathTailCol] = true;
                for (int i = 0; i < KuhnMunkresMatrixImplementation.this.excessMatrix.length; ++i) {
                    boolean extending;
                    if (KuhnMunkresMatrixImplementation.this.excessMatrix[i][pathTailCol] != 0.0 || this.rowsVisited[i] || !(extending = this.extendMatchingOL(i, pathTailCol))) continue;
                    return true;
                }
                return false;
            }
        }
    }
}

