% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_PS.R
\name{tf_PS}
\alias{tf_PS}
\title{Transform Phylostratum Values}
\usage{
tf_PS(phyex_set, transform = "qr")
}
\arguments{
\item{phyex_set}{a \code{PhyloExpressionSet} S7 object.}

\item{transform}{a character vector of any valid function that transforms PS values.
Possible values can be:
\itemize{
\item \code{transform} = \code{"qr"} (or \code{"quantilerank"}) :
quantile rank transformation analogous to Julia function \code{StatsBase.quantilerank}
using \code{method = :tied}.
}}
}
\value{
a \code{PhyloExpressionSet} object storing transformed Phylostratum levels.
}
\description{
This function performs transformation of phylostratum values.
}
\details{
This function transforms the phylostratum assignment.
The return value of this function is a PhyloExpressionSet object with
transformed phylostratum \code{tfPhylostratum} as the first column, satisfying
\code{\link{PhyloExpressionSetBase}}. Note that the input \code{transform} must be an
available function, currently limited to only \code{"qr"} (or \code{"quantilerank"}).
}
\examples{

# get the relative expression profiles for each phylostratum
tfPES <- tf_PS(example_phyex_set, transform = "qr")

}
\seealso{
\code{\link{tf}}
}
\author{
Jaruwatana Sodai Lotharukpong and Lukas Maischak
}
