% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{emr_time}
\alias{emr_time}
\alias{hours}
\alias{hour}
\alias{days}
\alias{day}
\alias{weeks}
\alias{week}
\alias{months}
\alias{month}
\alias{years}
\alias{year}
\title{Convert time periods to internal time format}
\usage{
emr_time(days = 0, months = 0, years = 0, hours = 0)

hours(n)

hour()

days(n)

day()

weeks(n)

week()

day()

months(n)

month()

years(n)

year()
}
\arguments{
\item{days}{number of days}

\item{months}{number of months}

\item{years}{number of years}

\item{hours}{number of hours}

\item{n}{number of days/weeks/months/years/hours}
}
\value{
Machine time format (number of hours)
}
\description{
Convert time periods to internal time format
}
\details{
\code{emr_time} converts a generic number of years, months day and hours to the internal
naryn machine format (which is hours).

\code{year}, \code{years}, \code{month}, \code{months}, \code{week}, \code{weeks},
\code{day}, \code{days}, \code{hour}, \code{hours}
are other convenience functions to get a time period explicitly.
}
\examples{

emr_time(5) # 5 days
emr_time(months = 4) # 4 months
emr_time(2, 4, 1) # 1 year, 4 months and 2 days

year() # 1 year
years(5) # 5 years
month() # 1 month
months(5) # 5 months
day() # 1 day
days(9) # 9 days
week() # 1 week
weeks(2) # 2 weeks
hour() # 1 hour
hours(5) # 5 hours
}
