% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finite_img.R
\docType{methods}
\name{finite_img-methods}
\alias{finite_img-methods}
\alias{finite_img}
\alias{finite_img,nifti-method}
\alias{finite_img,array-method}
\alias{finite_img,ANY-method}
\alias{finite_img,character-method}
\alias{finite_img,list-method}
\title{Finite Image}
\usage{
finite_img(img, replace = 0)

\S4method{finite_img}{nifti}(img, replace = 0)

\S4method{finite_img}{array}(img, replace = 0)

\S4method{finite_img}{ANY}(img, replace = 0)

\S4method{finite_img}{character}(img, replace = 0)

\S4method{finite_img}{list}(img, replace = 0)
}
\arguments{
\item{img}{character path of image or 
an object of class \code{nifti}, or list of images}

\item{replace}{Value to replace non-finite values to}
}
\value{
nifti object
}
\description{
Simple wrapper for setting non-finite values to zero
}
\examples{
set.seed(5)
dims = rep(10, 3)
arr = array(rpois(prod(dims), lambda = 2), dim = dims)
arr[c(5, 6, 7, 8)] = c(NA, NaN, Inf, -Inf)
nim = nifti(arr)
finite_img(nim)
finite_img(arr)
tfile = tempimg(nim)
checkimg(c(tfile, tfile))
checkimg(list(tfile, tfile))
finite_img(list(tfile, tfile))
finite_img(c(tfile, tfile))
img = RNifti::readNifti(tfile)
checkimg(img)
img[c(5, 6, 7, 8)] = c(NA, NaN, Inf, -Inf)
stopifnot(!any(c(is.na(c(finite_img(img))))))
}
\author{
John Muschelli \email{muschellij2@gmail.com}
}
