% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhl_players_seasons.R
\name{nhl_players_seasons}
\alias{nhl_players_seasons}
\title{Retrieve selected seasons statistics for players}
\usage{
nhl_players_seasons(playerNames, seasons, playerIds = NULL, playoffs = FALSE)
}
\arguments{
\item{playerNames}{\code{character()}, vector of one or more player names.
Not case sensitive for convenience.}

\item{seasons}{\code{numeric()}, \code{integer()} or \code{character()},
vector of starting years of desired seasons in \code{YYYY}
format, e.g. \code{1995} or \code{"1995"} for season 1995-1996.
Accepts vectors such as \code{c(1995:2000, 2010)} to generate
multiple seasons.

Alternatively, also accepts \code{character()} with seasons in the
format \code{"YYYYZZZZ"}, where \code{ZZZZ = YYYY + 1}, e.g. \code{"19951996"}.
This is the format that ultimately gets sent to the NHL API.

Some API endpoints, notably \code{seasons} exposed via \code{\link[=nhl_seasons]{nhl_seasons()}}
also allow the value \code{"current"} to passed. This value will be
returned unchanged.}

\item{playerIds}{\code{integer()}, vector of one or more ids of the
players. The ids correspond to the ids expected by the NHL
API people endpoint. For most cases the \code{playerNames} argument
can be provided for more convenient usage.}

\item{playoffs}{\code{logical(1)}, if \code{FALSE} (default) get the regular
seasons data, if \code{TRUE}, get the data for the playoffs.}
}
\value{
\code{data.frame}, with selected season statistics
for selected players.
}
\description{
Retrieve selected seasons statistics for players
}
\examples{
\dontrun{
 nhl_players_seasons(
   playerIds = c(8451101, 8458554),
   seasons = "19951996",
   playoffs = TRUE
 )
}
}
