% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.ztest.R
\name{plotztest}
\alias{plotztest}
\title{Illustrate a one- or two-tailed z test graphically.}
\usage{
plotztest(
  z,
  tails = "two",
  blank = FALSE,
  xmax = "auto",
  title = "z test",
  xlabel = "z",
  ylabel = "Density of probability\\nunder the null hypothesis",
  fontfamily = "serif",
  colormiddle = "aliceblue",
  colorsides = "firebrick3",
  colormiddlecurve = "black",
  colorsidescurve = "black",
  colorcut = "black",
  colorplabel = colorsides,
  theme = "default",
  signifdigitsz = 3,
  curvelinesize = 0.4,
  cutlinesize = curvelinesize,
  p_value_position = "auto"
)
}
\arguments{
\item{z}{A numeric value indicating the observed z statistic.}

\item{tails}{A character that indicates whether to plot a one (\code{"one"}) or two (\code{"two"}) tailed z-test (optional). By default, a two-tailed test is plotted.}

\item{blank}{A logical that indicates whether to hide (\code{blank = TRUE}) the test statistic value, p value and cutline. The corresponding colors are actually only made transparent when \code{blank = TRUE}, so that the output is scaled exactly the same (this is useful and especially intended for step-by-step explanations).}

\item{xmax}{A numeric including the maximum for the x-axis. Defaults to \code{"auto"}, which scales the plot automatically (optional).}

\item{title}{A character or expression indicating a custom title for the plot (optional).}

\item{xlabel}{A character or expression indicating a custom title for the x axis (optional).}

\item{ylabel}{A character or expression indicating a custom title for the y axis (optional).}

\item{fontfamily}{A character indicating the font family of all the titles and labels (e.g. \code{"serif"} (default), \code{"sans"}, \code{"Helvetica"}, \code{"Palatino"}, etc.) (optional).}

\item{colormiddle}{A character indicating the color for the "middle" area under the curve (optional).}

\item{colorsides}{A character indicating the color for the "side(s)" area(s) under the curve (optional).}

\item{colormiddlecurve}{A character indicating the color for the "middle" part of the curve (optional).}

\item{colorsidescurve}{A character indicating the color for the "side(s)" part of the curve (optional).}

\item{colorcut}{A character indicating the color for the cut line at the observed test statistic (optional).}

\item{colorplabel}{A character indicating the color for the label of the p-value (optional). By default, for color consistency, this color is the same as color of \code{colorright}.}

\item{theme}{A character indicating one of the predefined color themes. The themes are \code{"default"} (light blue and red), \code{"blackandwhite"}, \code{"whiteandred"}, \code{"blueandred"}, \code{"greenandred"} and \code{"goldandblue"}) (optional). Supersedes \code{colormiddle} and \code{colorsides} if another argument than \code{"default"} is provided.}

\item{signifdigitsz}{A numeric indicating the number of desired significant figures reported for the z label (optional).}

\item{curvelinesize}{A numeric indicating the size of the curve line (optional).}

\item{cutlinesize}{A numeric indicating the size of the cut line(s) (optional). By default, the size of the curve line is used.}

\item{p_value_position}{A numeric vector of length 2, indicating the x and y coordinates of the p-value label. By default, the position is set to \code{"auto"}. Note that the absolute value is used, and the sign is ignored. The position is set to the right if the test statistic value is positive, to the left if the test statistic value is negative, and on both sides if a two tailed test is plotted.}
}
\value{
Returns a plot with the density of probability of z under the null hypothesis, annotated with the observed z statistic and the p-value.
}
\description{
This function plots the density probability distribution of a z statistic, with appropriate vertical cutlines at the z value. The p-value and the observed z value are plotted. Although largely customizable, only one argument is required (the observed z statistic) for a two-tailed z test. The optional argument \code{tails = "one"} plots a one-tailed test plot (the tail is on the left or right, depending on the sign of the z statistic).
}
\examples{
#Making a z test plot with a z value of 2.
plotztest(2)

#The same plot without the z or p value
plotztest(2, blank = TRUE)

#Plotting a one-tailed test using the "tails" parameter.
plotztest(z = 2, tails = "one")

}
\author{
Nils Myszkowski <nmyszkowski@pace.edu>
}
