# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Find quantiles of the simulated data using Rcpp
#' @usage findSIMQ(SIM,
#'         X,
#'         Xbin,
#'         probs,
#'         confLevel,
#'         approx)
#' @param SIM A matrix of simulated data with only Y values collected.
#' @param X A numeric vector corresponding to Y
#' @param Xbin Binning result from makeCOVbin function
#' @param probs A numeric vector of probabilities
#' @param confLevel Confidence level of the interval.
#' @param approx Arguments to be passed to methods
#' @return quantiles of SIM using xbin
#' @export
#' @examples
#' data(origdata)
#' data(simdata)
#' CUT = FindBestCut(origdata$TIME,8)$cutoffs
#' time_bin = makeCOVbin(origdata$TIME,K=8,cutoffs = CUT)
#' findSIMQ(simdata,origdata$TIME,Xbin=time_bin,probs=c(0.1,0.5,0.9),
#' confLevel=0.95,approx=FALSE)
#' @exportPattern "^[[:alpha:]]+"
#' @importFrom Rcpp evalCpp
#' @useDynLib nlmeVPC
findSIMQ <- function(SIM, X, Xbin, probs, confLevel, approx) {
    .Call('_nlmeVPC_findSIMQ', PACKAGE = 'nlmeVPC', SIM, X, Xbin, probs, confLevel, approx)
}

