% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addResErr.R
\name{addResErr}
\alias{addResErr}
\title{Add residual error to a model}
\usage{
addResErr(ui, reserr, endpoint)
}
\arguments{
\item{ui}{The model as a function}

\item{reserr}{The type or types of residual error (currently
\code{"addSd"}, \code{"propSd"}, and \code{"lnormSd"} are
accepted)}

\item{endpoint}{the endpoint to apply the error; will default to
the first error in the model}
}
\value{
The model with residual error modified
}
\description{
Add residual error to a model
}
\details{
For \code{reserr}, the parameter will be named with the dependent
  variable from the model as a prefix.  For example, if the dependent
  variable in the model is \code{Cc}, the parameter name for \code{propSd}
  will become \code{CcpropSd}.
}
\examples{
library(rxode2)
readModelDb("PK_1cmt") |> addResErr("addSd")
readModelDb("PK_1cmt") |> addResErr("lnormSd")
readModelDb("PK_1cmt") |> addResErr(c("addSd", "propSd"))
}
