% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.net.R
\name{forecast.mlp}
\alias{forecast.mlp}
\title{Forecast using MLP neural network.}
\usage{
\method{forecast}{mlp}(object, h = NULL, y = NULL, xreg = NULL, ...)
}
\arguments{
\item{object}{MLP network object, produced using \code{\link{mlp}}.}

\item{h}{Forecast horizon. If NULL then h is set to match frequency of time series.}

\item{y}{Optionally forecast using different data than what the network was trained on. Expected to create havoc and do really bad things!}

\item{xreg}{Exogenous regressors. Each column is a different regressor and the sample size must be at least as long as the target in-sample set plus the forecast horizon, but can be longer. Set it to NULL if no xreg inputs are used.}

\item{...}{Unused argument.}
}
\value{
An object of classes "\code{forecast.net}" and "\code{forecast}".
  The function \code{plot} produces a plot of the forecasts.
  An object of class \code{"forecast.net"} is a list containing the following elements:
\itemize{
\item{\code{method}{ - The name of the forecasting method as a character string}}
\item{\code{mean}{ - Point forecasts as a time series}}
\item{\code{all.mean}{ - An array h x reps of all ensemble members forecasts, where reps are the number of ensemble members.}}
\item{\code{x}{ - The original time series used to create the network.}}
\item{\code{fitted}{ - Fitted values.}}
\item{\code{residuals}{ - Residuals from the fitted network.}}
}
}
\description{
Create forecasts using MLP neural networks.
}
\examples{
\dontshow{
 fit <- mlp(AirPassengers,reps=1)
 frc <- forecast(fit,h=36)
 print(frc)
 plot(frc)
}
\dontrun{
 fit <- mlp(AirPassengers)
 plot(fit)
 frc <- forecast(fit,h=36)
 plot(frc)
}

}
\seealso{
\code{\link{mlp}}, \code{\link{mlp.thief}}, \code{\link{elm}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
\keyword{mlp}
\keyword{thief}
\keyword{ts}
