% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.net.R
\name{plot.mlp}
\alias{plot.mlp}
\title{Plot MLP network.}
\usage{
\method{plot}{mlp}(x, r = 1, ...)
}
\arguments{
\item{x}{MLP network object, produced using \code{\link{mlp}}.}

\item{r}{Ensemple member to plot.}

\item{...}{Unused argument.}
}
\value{
None. Function produces a plot.
}
\description{
Produces a plot of the MLP network architecture.
}
\note{
Neurons are coloured with \code{"lightgrey"}. Seasonal dummies are coloured with \code{"lightpink"} and xreg with \code{"lightblue"}.
}
\examples{
\dontshow{
 fit <- mlp(AirPassengers,reps=1)
 plot(fit)
}
\dontrun{
 fit <- mlp(AirPassengers)
 print(fit)
 plot(fit)
 frc <- forecast(fit,h=36)
 plot(frc)
}

}
\seealso{
\code{\link{elm}}, \code{\link{mlp}}.
}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}
}
\keyword{mlp}
\keyword{thief}
\keyword{ts}
