% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhav.R
\name{bhav}
\alias{bhav}
\title{Bhavcopy from NSE and BSE}
\source{
<https://www.nseindia.com/all-reports>, <https://www.bseindia.com/markets/marketinfo/BhavCopy.aspx>
}
\usage{
bhav(x, se = "NSE")
}
\arguments{
\item{x}{numeric date format}

\item{se}{Stock Exchange either 'NSE' or 'BSE'. Default is 'NSE'.}
}
\value{
Bhavcopy for the given date.
}
\description{
Bhavcopy from NSE and BSE
}
\details{
Gets Bhavcopy from NSE and BSE for the given date.
}
\note{
The date should be strictly numerical and mentioned in quotation mark (refer examples). `bhav` can be used to download NSE bhavcopy from 1 Jan 2020 on wards.
}
\examples{
\donttest{
#Download Bhavcopy from NSE
report = bhav("01072024") # Download bhavcopy for 01 July 2024

#Download bhavcopy from BSE
report = bhav("01072024", 'BSE')
}
}
\seealso{
\code{\link[nser]{bhavpr}}\code{\link[nser]{bhavtoday}}
}
\author{
Nandan L. Patil \email{tryanother609@gmail.com}
}
